/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.core.internal.exceptions.Sneaky;

public final class JdbiClassUtils {
    public static final Method EQUALS_METHOD = JdbiClassUtils.methodLookup(Object.class, "equals", Object.class);
    public static final Method HASHCODE_METHOD = JdbiClassUtils.methodLookup(Object.class, "hashCode", new Class[0]);
    public static final Method TOSTRING_METHOD = JdbiClassUtils.methodLookup(Object.class, "toString", new Class[0]);
    private static final Object[] NO_ARGS = new Object[0];
    private static final Class<?>[] NO_PARAMS = new Class[0];
    private static final ConcurrentMap<Class<?>, MethodHandle> METHOD_HANDLE_CACHE = new ConcurrentHashMap();

    private JdbiClassUtils() {
        throw new UtilityClassException();
    }

    public static boolean isPresent(String klass) {
        try {
            Class.forName(klass);
            return true;
        }
        catch (ReflectiveOperationException ignored) {
            return false;
        }
    }

    public static Method methodLookup(Class<?> klass, String methodName, Class<?> ... parameterTypes) {
        try {
            return klass.getMethod(methodName, parameterTypes);
        }
        catch (ReflectiveOperationException | SecurityException e) {
            try {
                return klass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (ReflectiveOperationException | SecurityException e2) {
                e.addSuppressed(e2);
                throw new IllegalStateException(String.format("can't find %s#%s%s", klass.getName(), methodName, Arrays.asList(parameterTypes)), e);
            }
        }
    }

    public static Optional<Method> safeMethodLookup(Class<?> klass, String methodName, Class<?> ... parameterTypes) {
        try {
            return Optional.of(klass.getMethod(methodName, parameterTypes));
        }
        catch (ReflectiveOperationException | SecurityException ignored) {
            try {
                return Optional.of(klass.getDeclaredMethod(methodName, parameterTypes));
            }
            catch (ReflectiveOperationException | SecurityException ignored2) {
                return Optional.empty();
            }
        }
    }

    public static Stream<Class<?>> superTypes(Class<?> type) {
        Class<?>[] interfaces = type.getInterfaces();
        Set result = Stream.concat(Arrays.stream(interfaces).flatMap(JdbiClassUtils::superTypes), Arrays.stream(interfaces)).collect(Collectors.toSet());
        return result.stream();
    }

    public static Object[] safeVarargs(Object ... args) {
        return args == null ? NO_ARGS : args;
    }

    public static <T> T checkedCreateInstance(Class<T> type) {
        return JdbiClassUtils.checkedCreateInstance(type, NO_PARAMS, new Object[0]);
    }

    public static <T> T checkedCreateInstance(Class<T> type, Class<?>[] parameters, Object ... values) {
        try {
            MethodHandle methodHandle = MethodHandles.lookup().findConstructor(type, MethodType.methodType(Void.TYPE, parameters));
            methodHandle = methodHandle.asType(MethodType.methodType(type, parameters));
            return (T)methodHandle.invokeWithArguments(values);
        }
        catch (Throwable t) {
            throw Sneaky.throwAnyway(t);
        }
    }

    public static <T> T findConstructorAndCreateInstance(Class<T> type, Class<?>[] types, MethodHandleInvoker invoker) {
        try {
            MethodHandle ctorHandle = METHOD_HANDLE_CACHE.computeIfAbsent(type, t -> JdbiClassUtils.findCtorMethodHandleForParameters(t, types));
            return (T)invoker.createInstance(ctorHandle);
        }
        catch (Throwable t2) {
            throw Sneaky.throwAnyway(t2);
        }
    }

    public static <T> MethodHandleHolder<T> findConstructor(Class<T> type, Class<?> ... types) {
        MethodHandle ctorHandle = JdbiClassUtils.findCtorMethodHandleForParameters(type, types);
        return invoker -> {
            try {
                return invoker.createInstance(ctorHandle);
            }
            catch (Throwable t) {
                throw Sneaky.throwAnyway(t);
            }
        };
    }

    private static MethodHandle findCtorMethodHandleForParameters(Class<?> type, Class<?> ... types) {
        LinkedList<IllegalAccessException> suppressedThrowables = new LinkedList<IllegalAccessException>();
        Constructor<?>[] constructors = type.getConstructors();
        for (int argCount = types.length; argCount >= 0; --argCount) {
            block3: for (Constructor<?> constructor : constructors) {
                if (constructor.getParameterCount() != argCount) continue;
                for (int i = 0; i < argCount; ++i) {
                    if (!constructor.getParameterTypes()[i].isAssignableFrom(types[i])) continue block3;
                }
                try {
                    MethodHandle methodHandle = MethodHandles.lookup().unreflectConstructor(constructor);
                    if (argCount < types.length) {
                        methodHandle = MethodHandles.dropArguments(methodHandle, argCount, Arrays.copyOfRange(types, argCount, types.length));
                    }
                    return methodHandle.asType(methodHandle.type().changeReturnType(Object.class));
                }
                catch (IllegalAccessException e) {
                    suppressedThrowables.add(e);
                }
            }
        }
        NoSuchMethodException failure = new NoSuchMethodException(String.format("No constructor for class '%s', loosely matching arguments %s", type.getName(), Arrays.toString(types)));
        suppressedThrowables.forEach(failure::addSuppressed);
        return MethodHandles.dropArguments(MethodHandles.insertArguments(MethodHandles.throwException(Object.class, Exception.class), 0, failure), 0, types);
    }

    @FunctionalInterface
    public static interface MethodHandleInvoker {
        public Object createInstance(MethodHandle var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface MethodHandleHolder<T> {
        public T invoke(MethodHandleInvoker var1);
    }

    public static final class MethodKey {
        public final String name;
        public final MethodType type;

        public MethodKey(String name, MethodType type) {
            this.name = name;
            this.type = type;
        }

        public static MethodKey methodKey(Method method) {
            return new MethodKey(method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()));
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodKey)) {
                return false;
            }
            MethodKey castObj = (MethodKey)obj;
            return this.name.equals(castObj.name) && this.type.equals((Object)castObj.type);
        }

        public String toString() {
            return "MethodKey[" + this.name + "(" + this.type.parameterList().stream().map(Class::toString).collect(Collectors.joining(",")) + ")]";
        }
    }
}

