/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.config.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.config.internal.ConfigCache;

public final class ConfigCaches
implements JdbiConfig<ConfigCaches> {
    private final Map<ConfigCache<?, ?>, Map<Object, Object>> caches = new ConcurrentHashMap();

    @Override
    public ConfigCaches createCopy() {
        return this;
    }

    public static <K, V> ConfigCache<K, V> declare(Function<K, V> computer) {
        return ConfigCaches.declare(Function.identity(), computer);
    }

    public static <K, V> ConfigCache<K, V> declare(Function<K, ?> keyNormalizer, Function<K, V> computer) {
        return ConfigCaches.declare(keyNormalizer, (ConfigRegistry config, K k) -> computer.apply(k));
    }

    public static <K, V> ConfigCache<K, V> declare(BiFunction<ConfigRegistry, K, V> computer) {
        return ConfigCaches.declare(Function.identity(), computer);
    }

    public static <K, V> ConfigCache<K, V> declare(final Function<K, ?> keyNormalizer, final BiFunction<ConfigRegistry, K, V> computer) {
        return new ConfigCache<K, V>(){

            @Override
            public V get(K key, ConfigRegistry config) {
                return config.get(ConfigCaches.class).caches.computeIfAbsent(this, x -> new ConcurrentHashMap()).computeIfAbsent(keyNormalizer.apply(key), x -> computer.apply(config, key));
            }
        };
    }
}

