/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect.internal;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.reflect.internal.PojoProperties;
import org.jdbi.v3.core.mapper.reflect.internal.PojoPropertiesFactory;

public class PojoTypes
implements JdbiConfig<PojoTypes> {
    private final Map<Class<?>, PojoPropertiesFactory> factories = new ConcurrentHashMap();
    private ConfigRegistry registry;

    public PojoTypes() {
    }

    private PojoTypes(PojoTypes other) {
        this.factories.putAll(other.factories);
    }

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    public PojoTypes register(Class<?> key, PojoPropertiesFactory factory) {
        this.factories.put(key, factory);
        return this;
    }

    public Optional<PojoProperties<?>> findFor(Type type) {
        return Optional.ofNullable(this.factories.get(GenericTypes.getErasedType(type))).map(ppf -> ppf.create(type, this.registry));
    }

    @Override
    public PojoTypes createCopy() {
        return new PojoTypes(this);
    }
}

