/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.annotation.UseExtensionHandler;
import org.jdbi.v3.core.internal.JdbiClassUtils;
import org.jdbi.v3.core.internal.exceptions.CheckedCallable;

final class UseExtensionAnnotationHandlerFactory
implements ExtensionHandler.ExtensionHandlerFactory {
    static final ExtensionHandler.ExtensionHandlerFactory FACTORY = new UseExtensionAnnotationHandlerFactory();

    UseExtensionAnnotationHandlerFactory() {
    }

    @Override
    public boolean accepts(Class<?> extensionType, Method method) {
        if (method.isBridge()) {
            return false;
        }
        return !UseExtensionAnnotationHandlerFactory.findAnnotations(method).isEmpty();
    }

    private static boolean matchAnnotation(Annotation a) {
        return a.annotationType().isAnnotationPresent(UseExtensionHandler.class);
    }

    static List<Class<?>> findAnnotations(Method method) {
        return Stream.of(method.getAnnotations()).filter(UseExtensionAnnotationHandlerFactory::matchAnnotation).map(Annotation::annotationType).collect(Collectors.toList());
    }

    @Override
    public Optional<ExtensionHandler> buildExtensionHandler(Class<?> extensionType, Method method) {
        List<Class<?>> extensionAnnotations = UseExtensionAnnotationHandlerFactory.findAnnotations(method);
        if (extensionAnnotations.size() > 1) {
            throw new IllegalStateException(String.format("Mutually exclusive extension annotations on method %s.%s: %s", extensionType.getName(), method.getName(), extensionAnnotations));
        }
        if (method.isDefault() && !method.isSynthetic()) {
            throw new IllegalStateException(String.format("Default method %s.%s has @%s annotation. Extension type methods may be default, or have a @UseExtensionHandler annotation, but not both.", extensionType.getSimpleName(), method.getName(), extensionAnnotations.get(0).getSimpleName()));
        }
        return extensionAnnotations.stream().map(type -> type.getAnnotation(UseExtensionHandler.class)).map(a -> this.createExtensionHandler(a.value(), extensionType, method)).findFirst();
    }

    private ExtensionHandler createExtensionHandler(Class<? extends ExtensionHandler> handlerType, Class<?> extensionObjectType, Method method) {
        CheckedCallable[] callables;
        for (CheckedCallable callable : callables = new CheckedCallable[]{() -> handlerType.getConstructor(Class.class, Method.class).newInstance(extensionObjectType, method), () -> handlerType.getConstructor(Method.class).newInstance(method), () -> handlerType.getConstructor(new Class[0]).newInstance(new Object[0])}) {
            Optional handler = JdbiClassUtils.createInstanceIfPossible(callable);
            if (!handler.isPresent()) continue;
            return (ExtensionHandler)handler.get();
        }
        throw new IllegalStateException(String.format("ExtensionHandler class %s cannot be instantiated. Expected a constructor with parameters (Class, Method), (Method), or ().", handlerType));
    }
}

