/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.ExtensionHandlerCustomizer;
import org.jdbi.v3.core.extension.annotation.ExtensionCustomizationOrder;
import org.jdbi.v3.core.extension.annotation.UseExtensionCustomizer;
import org.jdbi.v3.core.internal.JdbiClassUtils;
import org.jdbi.v3.core.internal.exceptions.CheckedCallable;

final class UseExtensionAnnotationHandlerCustomizer
implements ExtensionHandlerCustomizer {
    static final ExtensionHandlerCustomizer HANDLER = new UseExtensionAnnotationHandlerCustomizer();

    UseExtensionAnnotationHandlerCustomizer() {
    }

    @Override
    public ExtensionHandler customize(ExtensionHandler delegate, Class<?> extensionType, Method method) {
        ExtensionHandler extensionHandler = delegate;
        List annotationTypes = Stream.of(method, extensionType).map(AnnotatedElement::getAnnotations).flatMap(Arrays::stream).map(Annotation::annotationType).filter(type -> type.isAnnotationPresent(UseExtensionCustomizer.class)).collect(Collectors.toCollection(ArrayList::new));
        Stream.of(method, extensionType).map(e -> e.getAnnotation(ExtensionCustomizationOrder.class)).filter(Objects::nonNull).findFirst().ifPresent(order -> annotationTypes.sort(this.createComparator((ExtensionCustomizationOrder)order).reversed()));
        List customizers = annotationTypes.stream().map(type -> type.getAnnotation(UseExtensionCustomizer.class)).map(a -> UseExtensionAnnotationHandlerCustomizer.createCustomizer(a.value(), extensionType, method)).collect(Collectors.toList());
        for (ExtensionHandlerCustomizer customizer : customizers) {
            extensionHandler = customizer.customize(extensionHandler, extensionType, method);
        }
        return extensionHandler;
    }

    private Comparator<Class<? extends Annotation>> createComparator(ExtensionCustomizationOrder order) {
        List<Class<? extends Annotation>> ordering = Arrays.asList(order.value());
        return Comparator.comparingInt(type -> {
            int index = ordering.indexOf(type);
            return index == -1 ? ordering.size() : index;
        });
    }

    private static ExtensionHandlerCustomizer createCustomizer(Class<? extends ExtensionHandlerCustomizer> customizerType, Class<?> extensionObjectType, Method method) {
        CheckedCallable[] callables;
        for (CheckedCallable callable : callables = new CheckedCallable[]{() -> customizerType.getConstructor(new Class[0]).newInstance(new Object[0]), () -> customizerType.getConstructor(Method.class).newInstance(method), () -> customizerType.getConstructor(Class.class, Method.class).newInstance(extensionObjectType, method)}) {
            Optional handler = JdbiClassUtils.createInstanceIfPossible(callable);
            if (!handler.isPresent()) continue;
            return (ExtensionHandlerCustomizer)handler.get();
        }
        throw new IllegalStateException(String.format("ExtensionHandlerCustomizer class %s cannot be instantiated. Expected a constructor with parameters (Class, Method), (Method), or ().", customizerType));
    }
}

