/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.config.ConfigCustomizer;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ConfigCustomizerFactory;
import org.jdbi.v3.core.extension.ExtensionConfigurer;
import org.jdbi.v3.core.extension.annotation.UseExtensionConfigurer;
import org.jdbi.v3.core.internal.JdbiClassUtils;

final class UseExtensionAnnotationConfigCustomizerFactory
implements ConfigCustomizerFactory {
    static final ConfigCustomizerFactory FACTORY = new UseExtensionAnnotationConfigCustomizerFactory();

    UseExtensionAnnotationConfigCustomizerFactory() {
    }

    @Override
    public Collection<ConfigCustomizer> forExtensionType(Class<?> extensionType) {
        ConfigurerMethod forType = (configurer, config, annotation) -> configurer.configureForType(config, annotation, extensionType);
        return UseExtensionAnnotationConfigCustomizerFactory.buildConfigCustomizer(Stream.concat(JdbiClassUtils.superTypes(extensionType), Stream.of(extensionType)), forType);
    }

    @Override
    public Collection<ConfigCustomizer> forExtensionMethod(Class<?> extensionType, Method method) {
        ConfigurerMethod forMethod = (configurer, config, annotation) -> configurer.configureForMethod(config, annotation, extensionType, method);
        return UseExtensionAnnotationConfigCustomizerFactory.buildConfigCustomizer(Stream.of(method), forMethod);
    }

    private static Collection<ConfigCustomizer> buildConfigCustomizer(Stream<AnnotatedElement> elements, ConfigurerMethod consumer) {
        return elements.flatMap(ae -> Arrays.stream(ae.getAnnotations())).filter(a -> a.annotationType().isAnnotationPresent(UseExtensionConfigurer.class)).map(a -> {
            UseExtensionConfigurer meta = a.annotationType().getAnnotation(UseExtensionConfigurer.class);
            Class<? extends ExtensionConfigurer> klass = meta.value();
            try {
                ExtensionConfigurer configurer = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
                return config -> consumer.configure(configurer, config, (Annotation)a);
            }
            catch (ReflectiveOperationException | SecurityException e) {
                throw new IllegalStateException(String.format("Unable to instantiate class %s", klass), e);
            }
        }).collect(Collectors.toList());
    }

    private static interface ConfigurerMethod {
        public void configure(ExtensionConfigurer var1, ConfigRegistry var2, Annotation var3);
    }
}

