/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.extension;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.UnableToCreateExtensionException;

final class InstanceExtensionHandlerFactory
implements ExtensionHandler.ExtensionHandlerFactory {
    static final ExtensionHandler.ExtensionHandlerFactory INSTANCE = new InstanceExtensionHandlerFactory();

    InstanceExtensionHandlerFactory() {
    }

    @Override
    public boolean accepts(Class<?> extensionType, Method method) {
        return Modifier.isAbstract(method.getModifiers()) || !extensionType.isInterface() && method.getDeclaringClass() != Object.class;
    }

    @Override
    public Optional<ExtensionHandler> buildExtensionHandler(Class<?> extensionType, Method method) {
        try {
            return Optional.of(ExtensionHandler.createForMethod(method));
        }
        catch (IllegalAccessException e) {
            throw new UnableToCreateExtensionException(e, "Instance handler for %s couldn't unreflect %s", extensionType, method);
        }
    }
}

