/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.extension;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.extension.BridgeMethodExtensionHandlerFactory;
import org.jdbi.v3.core.extension.ConfigCustomizerFactory;
import org.jdbi.v3.core.extension.DefaultMethodExtensionHandlerFactory;
import org.jdbi.v3.core.extension.ExtensionFactory;
import org.jdbi.v3.core.extension.ExtensionFactoryDelegate;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.ExtensionHandlerCustomizer;
import org.jdbi.v3.core.extension.ExtensionMetadata;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.extension.InstanceExtensionHandlerFactory;
import org.jdbi.v3.core.extension.UseExtensionAnnotationConfigCustomizerFactory;
import org.jdbi.v3.core.extension.UseExtensionAnnotationHandlerCustomizer;
import org.jdbi.v3.core.extension.UseExtensionAnnotationHandlerFactory;
import org.jdbi.v3.meta.Alpha;
import org.jdbi.v3.meta.Beta;

public class Extensions
implements JdbiConfig<Extensions> {
    private final List<ExtensionFactoryDelegate> extensionFactories = new CopyOnWriteArrayList<ExtensionFactoryDelegate>();
    private final ConcurrentMap<Class<?>, ExtensionMetadata> extensionMetadataCache = new ConcurrentHashMap();
    private final List<ExtensionHandlerCustomizer> extensionHandlerCustomizers = new CopyOnWriteArrayList<ExtensionHandlerCustomizer>();
    private final List<ExtensionHandler.ExtensionHandlerFactory> extensionHandlerFactories = new CopyOnWriteArrayList<ExtensionHandler.ExtensionHandlerFactory>();
    private final List<ConfigCustomizerFactory> configCustomizerFactories = new CopyOnWriteArrayList<ConfigCustomizerFactory>();
    private boolean allowProxy = true;

    public Extensions() {
        this.registerHandlerFactory(DefaultMethodExtensionHandlerFactory.INSTANCE);
        this.registerHandlerFactory(BridgeMethodExtensionHandlerFactory.INSTANCE);
        this.registerHandlerFactory(UseExtensionAnnotationHandlerFactory.FACTORY);
        this.registerHandlerCustomizer(UseExtensionAnnotationHandlerCustomizer.HANDLER);
        this.registerConfigCustomizerFactory(UseExtensionAnnotationConfigCustomizerFactory.FACTORY);
    }

    private Extensions(Extensions that) {
        this.allowProxy = that.allowProxy;
        this.extensionFactories.addAll(that.extensionFactories);
        this.extensionMetadataCache.putAll(that.extensionMetadataCache);
        this.extensionHandlerCustomizers.addAll(that.extensionHandlerCustomizers);
        this.extensionHandlerFactories.addAll(that.extensionHandlerFactories);
        this.configCustomizerFactories.addAll(that.configCustomizerFactories);
    }

    public Extensions register(ExtensionFactory factory) {
        this.extensionFactories.add(0, new ExtensionFactoryDelegate(factory));
        return this;
    }

    @Alpha
    public Extensions registerHandlerFactory(ExtensionHandler.ExtensionHandlerFactory extensionHandlerFactory) {
        this.extensionHandlerFactories.add(0, extensionHandlerFactory);
        return this;
    }

    @Alpha
    public Extensions registerHandlerCustomizer(ExtensionHandlerCustomizer extensionHandlerCustomizer) {
        this.extensionHandlerCustomizers.add(0, extensionHandlerCustomizer);
        return this;
    }

    @Alpha
    public Extensions registerConfigCustomizerFactory(ConfigCustomizerFactory configCustomizerFactory) {
        this.configCustomizerFactories.add(0, configCustomizerFactory);
        return this;
    }

    public boolean hasExtensionFor(Class<?> extensionType) {
        return this.findFactoryFor(extensionType).isPresent();
    }

    public <E> Optional<E> findFor(Class<E> extensionType, HandleSupplier handleSupplier) {
        return this.findFactoryFor(extensionType).map(factory -> factory.attach(extensionType, handleSupplier));
    }

    private Optional<ExtensionFactory> findFactoryFor(Class<?> extensionType) {
        for (ExtensionFactory extensionFactory : this.extensionFactories) {
            if (!extensionFactory.accepts(extensionType)) continue;
            return Optional.of(extensionFactory);
        }
        return Optional.empty();
    }

    public Optional<ExtensionFactory> findFactory(Class<? extends ExtensionFactory> factoryType) {
        for (ExtensionFactoryDelegate factory : this.extensionFactories) {
            if (!factoryType.isInstance(factory.getDelegatedFactory())) continue;
            return Optional.of(factory);
        }
        return Optional.empty();
    }

    @Alpha
    public ExtensionMetadata findMetadata(Class<?> extensionType, ConfigRegistry config, ExtensionFactory extensionFactory) {
        return this.extensionMetadataCache.computeIfAbsent(extensionType, this.createMetadata(config, extensionFactory));
    }

    private Function<Class<?>, ExtensionMetadata> createMetadata(ConfigRegistry config, ExtensionFactory extensionFactory) {
        return extensionType -> {
            ExtensionMetadata.Builder builder = ExtensionMetadata.builder(extensionType);
            extensionFactory.getExtensionHandlerFactories(config).forEach(builder::addExtensionHandlerFactory);
            this.extensionHandlerFactories.forEach(builder::addExtensionHandlerFactory);
            if (!extensionFactory.getFactoryFlags().contains((Object)ExtensionFactory.FactoryFlag.VIRTUAL_FACTORY)) {
                builder.addExtensionHandlerFactory(InstanceExtensionHandlerFactory.INSTANCE);
            }
            extensionFactory.getExtensionHandlerCustomizers(config).forEach(builder::addExtensionHandlerCustomizer);
            this.extensionHandlerCustomizers.forEach(builder::addExtensionHandlerCustomizer);
            extensionFactory.getConfigCustomizerFactories(config).forEach(builder::addConfigCustomizerFactory);
            this.configCustomizerFactories.forEach(builder::addConfigCustomizerFactory);
            extensionFactory.buildExtensionInitData(builder);
            return builder.build();
        };
    }

    @Beta
    public Extensions setAllowProxy(boolean allowProxy) {
        this.allowProxy = allowProxy;
        return this;
    }

    @Beta
    public boolean isAllowProxy() {
        return this.allowProxy;
    }

    @Override
    public Extensions createCopy() {
        return new Extensions(this);
    }

    @Beta
    public void onCreateProxy() {
        if (!this.isAllowProxy()) {
            throw new IllegalStateException("Creating onDemand proxy disallowed. Ensure @GenerateSqlObject annotation is being processed by `jdbi3-generator` annotation processor.");
        }
    }
}

