/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.extension;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.jdbi.v3.core.config.ConfigCustomizer;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.internal.ConfigCustomizerChain;
import org.jdbi.v3.core.extension.ConfigCustomizerFactory;
import org.jdbi.v3.core.extension.ExtensionContext;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.ExtensionHandlerCustomizer;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.extension.UnableToCreateExtensionException;
import org.jdbi.v3.core.internal.JdbiClassUtils;
import org.jdbi.v3.core.internal.exceptions.Sneaky;
import org.jdbi.v3.meta.Alpha;

@Alpha
public final class ExtensionMetadata {
    private final Class<?> extensionType;
    private final ConfigCustomizer instanceConfigCustomizer;
    private final Map<Method, ? extends ConfigCustomizer> methodConfigCustomizers;
    private final Map<Method, ExtensionHandler> methodHandlers;

    public static Builder builder(Class<?> extensionType) {
        return new Builder(extensionType);
    }

    private ExtensionMetadata(Class<?> extensionType, ConfigCustomizer instanceConfigCustomizer, Map<Method, ? extends ConfigCustomizer> methodConfigCustomizers, Map<Method, ExtensionHandler> methodHandlers) {
        this.extensionType = extensionType;
        this.instanceConfigCustomizer = instanceConfigCustomizer;
        this.methodConfigCustomizers = Collections.unmodifiableMap(methodConfigCustomizers);
        this.methodHandlers = Collections.unmodifiableMap(methodHandlers);
    }

    public Class<?> extensionType() {
        return this.extensionType;
    }

    public ConfigRegistry createInstanceConfiguration(ConfigRegistry config) {
        ConfigRegistry instanceConfiguration = config.createCopy();
        this.instanceConfigCustomizer.customize(instanceConfiguration);
        return instanceConfiguration;
    }

    public ConfigRegistry createMethodConfiguration(Method method, ConfigRegistry config) {
        ConfigRegistry methodConfiguration = config.createCopy();
        ConfigCustomizer methodConfigCustomizer = this.methodConfigCustomizers.get(method);
        if (methodConfigCustomizer != null) {
            methodConfigCustomizer.customize(methodConfiguration);
        }
        return methodConfiguration;
    }

    public Set<Method> getExtensionMethods() {
        return this.methodHandlers.keySet();
    }

    public <E> ExtensionHandlerInvoker createExtensionHandlerInvoker(E target, Method method, HandleSupplier handleSupplier, ConfigRegistry config) {
        return new ExtensionHandlerInvoker(target, method, this.methodHandlers.get(method), handleSupplier, config);
    }

    public static final class Builder {
        private final Class<?> extensionType;
        private final Collection<ExtensionHandler.ExtensionHandlerFactory> extensionHandlerFactories = new ArrayList<ExtensionHandler.ExtensionHandlerFactory>();
        private final Collection<ExtensionHandlerCustomizer> extensionHandlerCustomizers = new ArrayList<ExtensionHandlerCustomizer>();
        private final Collection<ConfigCustomizerFactory> configCustomizerFactories = new ArrayList<ConfigCustomizerFactory>();
        private final ConfigCustomizerChain instanceConfigCustomizer = new ConfigCustomizerChain();
        private final Map<Method, ConfigCustomizerChain> methodConfigCustomizers = new HashMap<Method, ConfigCustomizerChain>();
        private final Map<Method, ExtensionHandler> methodHandlers = new HashMap<Method, ExtensionHandler>();
        private final Collection<Method> extensionTypeMethods = new HashSet<Method>();

        Builder(Class<?> extensionType) {
            this.extensionType = extensionType;
            this.extensionTypeMethods.addAll(Arrays.asList(extensionType.getMethods()));
            this.extensionTypeMethods.addAll(Arrays.asList(extensionType.getDeclaredMethods()));
            this.extensionTypeMethods.stream().filter(m -> !m.isSynthetic()).collect(Collectors.groupingBy(m -> Arrays.asList(m.getName(), Arrays.asList(m.getParameterTypes())))).values().stream().filter(methodCount -> methodCount.size() > 1).findAny().ifPresent(methods -> {
                throw new UnableToCreateExtensionException("%s has ambiguous methods (%s) found, please resolve with an explicit override", extensionType, methods);
            });
        }

        public Builder addExtensionHandlerFactory(ExtensionHandler.ExtensionHandlerFactory extensionHandlerFactory) {
            this.extensionHandlerFactories.add(extensionHandlerFactory);
            return this;
        }

        public Builder addExtensionHandlerCustomizer(ExtensionHandlerCustomizer extensionHandlerCustomizer) {
            this.extensionHandlerCustomizers.add(extensionHandlerCustomizer);
            return this;
        }

        public Builder addConfigCustomizerFactory(ConfigCustomizerFactory configCustomizerFactory) {
            this.configCustomizerFactories.add(configCustomizerFactory);
            return this;
        }

        public Builder addInstanceConfigCustomizer(ConfigCustomizer configCustomizer) {
            this.instanceConfigCustomizer.addCustomizer(configCustomizer);
            return this;
        }

        public Builder addMethodConfigCustomizer(Method method, ConfigCustomizer configCustomizer) {
            ConfigCustomizerChain methodConfigCustomizer = this.methodConfigCustomizers.computeIfAbsent(method, m -> new ConfigCustomizerChain());
            methodConfigCustomizer.addCustomizer(configCustomizer);
            return this;
        }

        public Builder addMethodHandler(Method method, ExtensionHandler handler) {
            this.methodHandlers.put(method, handler);
            return this;
        }

        public Class<?> getExtensionType() {
            return this.extensionType;
        }

        public ExtensionMetadata build() {
            HashSet<Method> seen = new HashSet<Method>(this.methodHandlers.keySet());
            for (Method method : this.extensionTypeMethods) {
                if (Modifier.isStatic(method.getModifiers()) || !seen.add(method)) continue;
                ExtensionHandler handler = this.findExtensionHandlerFor(this.extensionType, method).orElseGet(() -> ExtensionHandler.missingExtensionHandler(method));
                for (ExtensionHandlerCustomizer extensionHandlerCustomizer : this.extensionHandlerCustomizers) {
                    handler = extensionHandlerCustomizer.customize(handler, this.extensionType, method);
                }
                this.methodHandlers.put(method, handler);
            }
            this.configCustomizerFactories.forEach(configCustomizerFactory -> configCustomizerFactory.forExtensionType(this.extensionType).forEach(this::addInstanceConfigCustomizer));
            for (Method method : this.methodHandlers.keySet()) {
                this.configCustomizerFactories.forEach(configCustomizerFactory -> configCustomizerFactory.forExtensionMethod(this.extensionType, method).forEach(configCustomizer -> this.addMethodConfigCustomizer(method, (ConfigCustomizer)configCustomizer)));
            }
            return new ExtensionMetadata(this.extensionType, this.instanceConfigCustomizer, this.methodConfigCustomizers, this.methodHandlers);
        }

        private Optional<? extends ExtensionHandler> findExtensionHandlerFor(Class<?> extensionType, Method method) {
            for (ExtensionHandler.ExtensionHandlerFactory extensionHandlerFactory : this.extensionHandlerFactories) {
                Optional<ExtensionHandler> result;
                if (!extensionHandlerFactory.accepts(extensionType, method) || !(result = extensionHandlerFactory.buildExtensionHandler(extensionType, method)).isPresent()) continue;
                return result;
            }
            return Optional.empty();
        }
    }

    public final class ExtensionHandlerInvoker {
        private final Object target;
        private final HandleSupplier handleSupplier;
        private final ExtensionContext extensionContext;
        private final ExtensionHandler extensionHandler;

        ExtensionHandlerInvoker(Object target, Method method, ExtensionHandler extensionHandler, HandleSupplier handleSupplier, ConfigRegistry config) {
            this.target = target;
            this.handleSupplier = handleSupplier;
            ConfigRegistry methodConfig = ExtensionMetadata.this.createMethodConfiguration(method, config);
            this.extensionContext = ExtensionContext.forExtensionMethod(methodConfig, ExtensionMetadata.this.extensionType, method);
            this.extensionHandler = extensionHandler;
            this.extensionHandler.warm(methodConfig);
        }

        public Object invoke(Object ... args) {
            Object[] handlerArgs = JdbiClassUtils.safeVarargs(args);
            Callable<Object> callable = () -> this.extensionHandler.invoke(this.handleSupplier, this.target, handlerArgs);
            return this.call(callable);
        }

        public Object call(Callable<?> callable) {
            try {
                return this.handleSupplier.invokeInContext(this.extensionContext, callable);
            }
            catch (Exception x) {
                throw Sneaky.throwAnyway(x);
            }
        }

        public void call(Runnable runnable) {
            this.call(() -> {
                runnable.run();
                return null;
            });
        }
    }
}

