/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.extension;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Optional;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.extension.PrivateLookupInKludge;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.meta.Alpha;
import org.jdbi.v3.meta.Beta;

@FunctionalInterface
@Alpha
public interface ExtensionHandler {
    public static final ExtensionHandler EQUALS_HANDLER = (handleSupplier, target, args) -> target == args[0];
    public static final ExtensionHandler HASHCODE_HANDLER = (handleSupplier, target, args) -> System.identityHashCode(target);
    public static final ExtensionHandler NULL_HANDLER = (handleSupplier, target, args) -> null;

    public Object invoke(HandleSupplier var1, Object var2, Object ... var3) throws Exception;

    @Beta
    default public void warm(ConfigRegistry config) {
    }

    public static ExtensionHandler missingExtensionHandler(Method method) {
        return (target, args, handleSupplier) -> {
            throw new IllegalStateException(String.format("Method %s.%s has no registered extension handler!", method.getDeclaringClass().getSimpleName(), method.getName()));
        };
    }

    public static ExtensionHandler createForMethod(Method method) throws IllegalAccessException {
        Class<?> declaringClass = method.getDeclaringClass();
        MethodHandle methodHandle = PrivateLookupInKludge.lookupFor(declaringClass).unreflect(method);
        return ExtensionHandler.createForMethodHandle(methodHandle);
    }

    public static ExtensionHandler createForSpecialMethod(Method method) throws IllegalAccessException {
        Class<?> declaringClass = method.getDeclaringClass();
        MethodHandle methodHandle = PrivateLookupInKludge.lookupFor(declaringClass).unreflectSpecial(method, declaringClass);
        return ExtensionHandler.createForMethodHandle(methodHandle);
    }

    public static ExtensionHandler createForMethodHandle(MethodHandle methodHandle) {
        return (handleSupplier, target, args) -> {
            if (target == null) {
                throw new IllegalStateException("no target object present, called from a proxy factory?");
            }
            return Unchecked.function(methodHandle.bindTo(target)::invokeWithArguments).apply(args);
        };
    }

    public static interface ExtensionHandlerFactory {
        public boolean accepts(Class<?> var1, Method var2);

        public Optional<ExtensionHandler> buildExtensionHandler(Class<?> var1, Method var2);
    }
}

