/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.extension;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ConfigCustomizerFactory;
import org.jdbi.v3.core.extension.ExtensionFactory;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.ExtensionHandlerCustomizer;
import org.jdbi.v3.core.extension.ExtensionMetadata;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.internal.JdbiClassUtils;

final class ExtensionFactoryDelegate
implements ExtensionFactory {
    private final ExtensionFactory delegatedFactory;

    ExtensionFactoryDelegate(ExtensionFactory delegatedFactory) {
        this.delegatedFactory = delegatedFactory;
    }

    @Override
    public boolean accepts(Class<?> extensionType) {
        return this.delegatedFactory.accepts(extensionType);
    }

    ExtensionFactory getDelegatedFactory() {
        return this.delegatedFactory;
    }

    @Override
    public Collection<ExtensionHandler.ExtensionHandlerFactory> getExtensionHandlerFactories(ConfigRegistry config) {
        return this.delegatedFactory.getExtensionHandlerFactories(config);
    }

    @Override
    public Collection<ExtensionHandlerCustomizer> getExtensionHandlerCustomizers(ConfigRegistry config) {
        return this.delegatedFactory.getExtensionHandlerCustomizers(config);
    }

    @Override
    public Collection<ConfigCustomizerFactory> getConfigCustomizerFactories(ConfigRegistry config) {
        return this.delegatedFactory.getConfigCustomizerFactories(config);
    }

    @Override
    public void buildExtensionInitData(ExtensionMetadata.Builder builder) {
        this.delegatedFactory.buildExtensionInitData(builder);
    }

    @Override
    public Set<ExtensionFactory.FactoryFlag> getFactoryFlags() {
        return this.delegatedFactory.getFactoryFlags();
    }

    @Override
    public <E> E attach(Class<E> extensionType, HandleSupplier handleSupplier) {
        Set<ExtensionFactory.FactoryFlag> factoryFlags = this.getFactoryFlags();
        if (factoryFlags.contains((Object)ExtensionFactory.FactoryFlag.CLASSES_ARE_SUPPORTED)) {
            return this.delegatedFactory.attach(extensionType, handleSupplier);
        }
        if (extensionType == null || !extensionType.isInterface()) {
            throw new IllegalArgumentException(String.format("Can not attach %s as an extension with %s", extensionType, this.delegatedFactory.getClass().getSimpleName()));
        }
        ConfigRegistry config = handleSupplier.getConfig();
        Extensions extensions = config.get(Extensions.class);
        extensions.onCreateProxy();
        ExtensionMetadata extensionMetaData = extensions.findMetadata(extensionType, config, this.delegatedFactory);
        ConfigRegistry instanceConfig = extensionMetaData.createInstanceConfiguration(config);
        HashMap handlers = new HashMap();
        Object proxy = Proxy.newProxyInstance(extensionType.getClassLoader(), new Class[]{extensionType}, (proxyInstance, method, args) -> ((ExtensionMetadata.ExtensionHandlerInvoker)handlers.get(method)).invoke(args));
        Object delegatedInstance = factoryFlags.contains((Object)ExtensionFactory.FactoryFlag.VIRTUAL_FACTORY) ? proxy : this.delegatedFactory.attach(extensionType, handleSupplier);
        this.checkMethodPresent(extensionType, Object.class, "toString", new Class[0]).ifPresent(method -> {
            ExtensionHandler toStringHandler = (h, target, args) -> "Jdbi extension proxy for " + extensionType.getName() + "@" + Integer.toHexString(proxy.hashCode());
            ExtensionMetadata extensionMetadata = extensionMetaData;
            Objects.requireNonNull(extensionMetadata);
            handlers.put(method, new ExtensionMetadata.ExtensionHandlerInvoker(extensionMetadata, proxy, (Method)method, toStringHandler, handleSupplier, instanceConfig));
        });
        this.checkMethodPresent(extensionType, Object.class, "equals", Object.class).ifPresent(method -> {
            ExtensionMetadata extensionMetadata = extensionMetaData;
            Objects.requireNonNull(extensionMetadata);
            handlers.put(method, new ExtensionMetadata.ExtensionHandlerInvoker(extensionMetadata, proxy, (Method)method, ExtensionHandler.EQUALS_HANDLER, handleSupplier, instanceConfig));
        });
        this.checkMethodPresent(extensionType, Object.class, "hashCode", new Class[0]).ifPresent(method -> {
            ExtensionMetadata extensionMetadata = extensionMetaData;
            Objects.requireNonNull(extensionMetadata);
            handlers.put(method, new ExtensionMetadata.ExtensionHandlerInvoker(extensionMetadata, proxy, (Method)method, ExtensionHandler.HASHCODE_HANDLER, handleSupplier, instanceConfig));
        });
        extensionMetaData.getExtensionMethods().forEach(method -> handlers.put(method, extensionMetaData.createExtensionHandlerInvoker(delegatedInstance, (Method)method, handleSupplier, instanceConfig)));
        JdbiClassUtils.safeMethodLookup(extensionType, "finalize", new Class[0]).ifPresent(method -> {
            ExtensionMetadata extensionMetadata = extensionMetaData;
            Objects.requireNonNull(extensionMetadata);
            handlers.put(method, new ExtensionMetadata.ExtensionHandlerInvoker(extensionMetadata, proxy, (Method)method, ExtensionHandler.NULL_HANDLER, handleSupplier, instanceConfig));
        });
        return extensionType.cast(proxy);
    }

    private Optional<Method> checkMethodPresent(Class<?> extensionType, Class<?> klass, String methodName, Class<?> ... parameterTypes) {
        Optional<Method> method = JdbiClassUtils.safeMethodLookup(extensionType, methodName, parameterTypes);
        if (method.isPresent()) {
            return Optional.empty();
        }
        return JdbiClassUtils.safeMethodLookup(klass, methodName, parameterTypes);
    }

    public String toString() {
        return "ExtensionFactoryDelegate for " + this.delegatedFactory.toString();
    }
}

