/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.extension;

import java.lang.reflect.Method;
import java.util.Optional;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.UnableToCreateExtensionException;

final class DefaultMethodExtensionHandlerFactory
implements ExtensionHandler.ExtensionHandlerFactory {
    static final ExtensionHandler.ExtensionHandlerFactory INSTANCE = new DefaultMethodExtensionHandlerFactory();

    DefaultMethodExtensionHandlerFactory() {
    }

    @Override
    public boolean accepts(Class<?> extensionType, Method method) {
        return extensionType.isInterface() && method.isDefault();
    }

    @Override
    public Optional<ExtensionHandler> buildExtensionHandler(Class<?> extensionType, Method method) {
        try {
            return Optional.of(ExtensionHandler.createForSpecialMethod(method));
        }
        catch (IllegalAccessException e) {
            throw new UnableToCreateExtensionException(e, "Default method handler for %s couldn't unreflect %s", extensionType, method);
        }
    }
}

