/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.extension;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.UnableToCreateExtensionException;

final class BridgeMethodExtensionHandlerFactory
implements ExtensionHandler.ExtensionHandlerFactory {
    static final ExtensionHandler.ExtensionHandlerFactory INSTANCE = new BridgeMethodExtensionHandlerFactory();

    BridgeMethodExtensionHandlerFactory() {
    }

    @Override
    public boolean accepts(Class<?> extensionType, Method method) {
        return method.isBridge();
    }

    @Override
    public Optional<ExtensionHandler> buildExtensionHandler(Class<?> extensionType, Method method) {
        List candidates = Stream.of(extensionType.getMethods()).filter(candidate -> !candidate.isBridge()).filter(candidate -> Objects.equals(candidate.getName(), method.getName())).filter(candidate -> candidate.getParameterCount() == method.getParameterCount()).filter(candidate -> {
            Class[] candidateParamTypes = candidate.getParameterTypes();
            Class[] methodParamTypes = method.getParameterTypes();
            return IntStream.range(0, method.getParameterCount()).allMatch(i -> methodParamTypes[i].isAssignableFrom(candidateParamTypes[i]));
        }).collect(Collectors.toList());
        for (Method candidate2 : candidates) {
            try {
                return Optional.of(ExtensionHandler.createForMethod(candidate2));
            }
            catch (IllegalAccessException illegalAccessException) {
            }
        }
        throw new UnableToCreateExtensionException("Could not create an extension handler for bridge method %s#%s.", extensionType, method);
    }
}

