/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.config;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.collector.JdbiCollectors;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.config.internal.ConfigCaches;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.mapper.ColumnMappers;
import org.jdbi.v3.core.mapper.Mappers;
import org.jdbi.v3.core.mapper.RowMappers;
import org.jdbi.v3.core.statement.SqlStatements;

public final class ConfigRegistry {
    private final Map<Class<? extends JdbiConfig<?>>, JdbiConfig<?>> configs = new ConcurrentHashMap(32);
    private final Map<Class<? extends JdbiConfig<?>>, Function<ConfigRegistry, JdbiConfig<?>>> configFactories;

    public ConfigRegistry() {
        this.configFactories = new ConcurrentHashMap();
        this.get(ConfigCaches.class);
        this.get(SqlStatements.class);
        this.get(Arguments.class);
        this.get(RowMappers.class);
        this.get(ColumnMappers.class);
        this.get(Mappers.class);
        this.get(JdbiCollectors.class);
    }

    private ConfigRegistry(ConfigRegistry that) {
        this.configFactories = that.configFactories;
        that.configs.forEach((type, config) -> {
            Object copy = config.createCopy();
            this.configs.put((Class<JdbiConfig<?>>)type, (JdbiConfig<?>)copy);
        });
        this.configs.values().forEach(c -> c.setRegistry(this));
    }

    public <C extends JdbiConfig<C>> C get(Class<C> configClass) {
        JdbiConfig<?> lookup = this.configs.get(configClass);
        if (lookup != null) {
            return (C)((JdbiConfig)configClass.cast(lookup));
        }
        JdbiConfig config = (JdbiConfig)configClass.cast(this.configFactory(configClass).apply(this));
        return (C)Optional.ofNullable((JdbiConfig)configClass.cast(this.configs.putIfAbsent(configClass, config))).orElse(config);
    }

    private Function<ConfigRegistry, JdbiConfig<?>> configFactory(Class<? extends JdbiConfig<?>> configClass) {
        return this.configFactories.computeIfAbsent(configClass, klass -> {
            NoSuchMethodException notFound;
            try {
                MethodHandle mh = MethodHandles.lookup().findConstructor((Class<?>)klass, MethodType.methodType(Void.TYPE, ConfigRegistry.class)).asType(MethodType.methodType(JdbiConfig.class, ConfigRegistry.class));
                return Unchecked.function(registry -> mh.invokeExact((ConfigRegistry)registry));
            }
            catch (NoSuchMethodException e) {
                notFound = e;
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Unable to use constructor taking ConfigRegistry to create " + configClass, e);
            }
            try {
                MethodHandle mh = MethodHandles.lookup().findConstructor((Class<?>)klass, MethodType.methodType(Void.TYPE)).asType(MethodType.methodType(JdbiConfig.class));
                return Unchecked.function(registry -> {
                    JdbiConfig result = mh.invokeExact();
                    result.setRegistry((ConfigRegistry)registry);
                    return result;
                });
            }
            catch (ReflectiveOperationException e) {
                IllegalStateException failure = new IllegalStateException("Unable to instantiate config class " + configClass + ". Is there a public no-arg constructor?", e);
                failure.addSuppressed(notFound);
                throw failure;
            }
        });
    }

    public ConfigRegistry createCopy() {
        return new ConfigRegistry(this);
    }
}

