/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.jdbi.v3.core.ConnectionException;
import org.jdbi.v3.core.ConnectionFactory;
import org.jdbi.v3.core.ConstantHandleSupplier;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.HandleConsumer;
import org.jdbi.v3.core.LazyHandleSupplier;
import org.jdbi.v3.core.SingleConnectionFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.Configurable;
import org.jdbi.v3.core.extension.ExtensionCallback;
import org.jdbi.v3.core.extension.ExtensionConsumer;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.extension.NoSuchExtensionException;
import org.jdbi.v3.core.internal.OnDemandExtensions;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.DefaultStatementBuilder;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.StatementBuilder;
import org.jdbi.v3.core.statement.StatementBuilderFactory;
import org.jdbi.v3.core.transaction.LocalTransactionHandler;
import org.jdbi.v3.core.transaction.TransactionHandler;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jdbi
implements Configurable<Jdbi> {
    private static final Logger LOG = LoggerFactory.getLogger(Jdbi.class);
    private final ConfigRegistry config = new ConfigRegistry();
    private final ConnectionFactory connectionFactory;
    private final AtomicReference<TransactionHandler> transactionhandler = new AtomicReference<LocalTransactionHandler>(LocalTransactionHandler.binding());
    private final AtomicReference<StatementBuilderFactory> statementBuilderFactory = new AtomicReference<StatementBuilderFactory>(DefaultStatementBuilder.FACTORY);
    private final CopyOnWriteArrayList<JdbiPlugin> plugins = new CopyOnWriteArrayList();
    private final ThreadLocal<HandleSupplier> threadHandleSupplier = new ThreadLocal();

    private Jdbi(ConnectionFactory connectionFactory) {
        Objects.requireNonNull(connectionFactory, "null connectionFactory");
        this.connectionFactory = connectionFactory;
    }

    public static Jdbi create(Connection connection) {
        return Jdbi.create(new SingleConnectionFactory(connection));
    }

    public static Jdbi create(DataSource dataSource) {
        return Jdbi.create(dataSource::getConnection);
    }

    public static Jdbi create(ConnectionFactory connectionFactory) {
        return new Jdbi(connectionFactory);
    }

    public static Jdbi create(String url) {
        Objects.requireNonNull(url, "null url");
        return Jdbi.create(() -> DriverManager.getConnection(url));
    }

    public static Jdbi create(String url, Properties properties) {
        Objects.requireNonNull(url, "null url");
        Objects.requireNonNull(properties, "null properties");
        return Jdbi.create(() -> DriverManager.getConnection(url, properties));
    }

    public static Jdbi create(String url, String username, String password) {
        Objects.requireNonNull(url, "null url");
        Objects.requireNonNull(username, "null username");
        Objects.requireNonNull(password, "null password");
        return Jdbi.create(() -> DriverManager.getConnection(url, username, password));
    }

    public static Handle open(DataSource dataSource) {
        return Jdbi.create(dataSource).open();
    }

    public static Handle open(ConnectionFactory connectionFactory) {
        return Jdbi.create(connectionFactory).open();
    }

    public static Handle open(Connection connection) {
        Objects.requireNonNull(connection, "null connection");
        return Jdbi.create(() -> connection).open();
    }

    public static Handle open(String url) {
        return Jdbi.create(url).open();
    }

    public static Handle open(String url, String username, String password) {
        return Jdbi.create(url, username, password).open();
    }

    public static Handle open(String url, Properties props) {
        return Jdbi.create(url, props).open();
    }

    public Jdbi installPlugins() {
        ServiceLoader.load(JdbiPlugin.class).forEach(this::installPlugin);
        LOG.debug("Automatically installed plugins {}", this.plugins);
        return this;
    }

    public Jdbi installPlugin(JdbiPlugin plugin) {
        if (this.plugins.addIfAbsent(plugin)) {
            Unchecked.consumer(plugin::customizeJdbi).accept(this);
        }
        return this;
    }

    public Jdbi setStatementBuilderFactory(StatementBuilderFactory factory) {
        this.statementBuilderFactory.set(factory);
        return this;
    }

    public StatementBuilderFactory getStatementBuilderFactory() {
        return this.statementBuilderFactory.get();
    }

    @Override
    public ConfigRegistry getConfig() {
        return this.config;
    }

    public Jdbi setTransactionHandler(TransactionHandler handler) {
        Objects.requireNonNull(handler, "null transaction handler");
        this.transactionhandler.set(handler);
        return this;
    }

    public TransactionHandler getTransactionHandler() {
        return this.transactionhandler.get();
    }

    public Handle open() {
        try {
            long start = System.nanoTime();
            Connection conn = Objects.requireNonNull(this.connectionFactory.openConnection(), () -> "Connection factory " + this.connectionFactory + " returned a null connection");
            long stop = System.nanoTime();
            for (JdbiPlugin p : this.plugins) {
                conn = p.customizeConnection(conn);
            }
            StatementBuilder cache = this.statementBuilderFactory.get().createStatementBuilder(conn);
            Handle h = Handle.createHandle(this, this.connectionFactory.getCleanableFor(conn), this.transactionhandler.get(), cache, conn);
            for (JdbiPlugin p : this.plugins) {
                h = p.customizeHandle(h);
            }
            LOG.trace("Jdbi [{}] obtain handle [{}] in {}ms", new Object[]{this, h, TimeUnit.MILLISECONDS.convert(stop - start, TimeUnit.NANOSECONDS)});
            return h;
        }
        catch (SQLException e) {
            throw new ConnectionException(e);
        }
    }

    public <R, X extends Exception> R withHandle(HandleCallback<R, X> callback) throws X {
        HandleSupplier handleSupplier = this.threadHandleSupplier.get();
        if (handleSupplier != null) {
            return callback.withHandle(handleSupplier.getHandle());
        }
        try {
            R r;
            block10: {
                Handle h = this.open();
                try {
                    SqlStatements sqlStatements = h.getConfig(SqlStatements.class);
                    sqlStatements.setAttachAllStatementsForCleanup(sqlStatements.isAttachCallbackStatementsForCleanup());
                    handleSupplier = ConstantHandleSupplier.of(h);
                    this.threadHandleSupplier.set(handleSupplier);
                    r = callback.withHandle(h);
                    if (h == null) break block10;
                    h.close();
                }
                catch (Throwable throwable) {
                    if (h != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            return r;
        }
        finally {
            this.threadHandleSupplier.remove();
        }
    }

    public <X extends Exception> void useHandle(HandleConsumer<X> consumer) throws X {
        this.withHandle(consumer.asCallback());
    }

    public <R, X extends Exception> R inTransaction(HandleCallback<R, X> callback) throws X {
        return (R)this.withHandle(handle -> handle.inTransaction(callback));
    }

    public <X extends Exception> void useTransaction(HandleConsumer<X> callback) throws X {
        this.useHandle(handle -> handle.useTransaction(callback));
    }

    public <R, X extends Exception> R inTransaction(TransactionIsolationLevel level, HandleCallback<R, X> callback) throws X {
        return (R)this.withHandle(handle -> handle.inTransaction(level, callback));
    }

    public <X extends Exception> void useTransaction(TransactionIsolationLevel level, HandleConsumer<X> callback) throws X {
        this.useHandle(handle -> handle.useTransaction(level, callback));
    }

    public <R, E, X extends Exception> R withExtension(Class<E> extensionType, ExtensionCallback<R, E, X> callback) throws X {
        HandleSupplier handleSupplier = this.threadHandleSupplier.get();
        if (handleSupplier != null) {
            return this.callWithExtension(extensionType, callback, handleSupplier);
        }
        try {
            R r;
            try (LazyHandleSupplier lazyHandleSupplier = new LazyHandleSupplier(this);){
                this.threadHandleSupplier.set(lazyHandleSupplier);
                r = this.callWithExtension(extensionType, callback, lazyHandleSupplier);
            }
            return r;
        }
        finally {
            this.threadHandleSupplier.remove();
        }
    }

    private <R, E, X extends Exception> R callWithExtension(Class<E> extensionType, ExtensionCallback<R, E, X> callback, HandleSupplier handleSupplier) throws X {
        E extension = this.getConfig(Extensions.class).findFor(extensionType, handleSupplier).orElseThrow(() -> new NoSuchExtensionException(extensionType));
        return callback.withExtension(extension);
    }

    public <E, X extends Exception> void useExtension(Class<E> extensionType, ExtensionConsumer<E, X> callback) throws X {
        this.withExtension(extensionType, extension -> {
            callback.useExtension(extension);
            return null;
        });
    }

    public <E> E onDemand(Class<E> extensionType) {
        if (!extensionType.isInterface()) {
            throw new IllegalArgumentException("On-demand extensions are only supported for interfaces.");
        }
        if (!this.getConfig(Extensions.class).hasExtensionFor(extensionType)) {
            throw new NoSuchExtensionException("Extension not found: " + extensionType);
        }
        return this.getConfig(OnDemandExtensions.class).create(this, extensionType, new Class[0]);
    }
}

