/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.internal.exceptions.Unchecked;

public class OnDemandExtensions
implements JdbiConfig<OnDemandExtensions> {
    private static final Method EQUALS_METHOD;
    private static final Method HASHCODE_METHOD;
    private static final Method TOSTRING_METHOD;
    private Factory onDemandExtensionFactory;

    public OnDemandExtensions() {
        this.onDemandExtensionFactory = (jdbi, extensionType, extraTypes) -> Optional.empty();
    }

    private OnDemandExtensions(OnDemandExtensions other) {
        this.onDemandExtensionFactory = other.onDemandExtensionFactory;
    }

    public OnDemandExtensions setFactory(Factory onDemandExtensionFactory) {
        this.onDemandExtensionFactory = onDemandExtensionFactory;
        return this;
    }

    public <E> E create(Jdbi db, Class<E> extensionType, Class<?> ... extraTypes) {
        return extensionType.cast(this.onDemandExtensionFactory.onDemand(db, extensionType, extraTypes).orElseGet(() -> this.createProxy(db, extensionType, extraTypes)));
    }

    private Object createProxy(Jdbi db, Class<?> extensionType, Class<?> ... extraTypes) {
        db.getConfig(Extensions.class).onCreateProxy();
        InvocationHandler handler = (proxy, method, args) -> {
            if (EQUALS_METHOD.equals(method)) {
                return proxy == args[0];
            }
            if (HASHCODE_METHOD.equals(method)) {
                return System.identityHashCode(proxy);
            }
            if (TOSTRING_METHOD.equals(method)) {
                return "Jdbi on demand proxy for " + extensionType.getName() + "@" + Integer.toHexString(System.identityHashCode(proxy));
            }
            return db.withExtension(extensionType, extension -> OnDemandExtensions.invoke(extension, method, args));
        };
        Class[] types = (Class[])Stream.of(Stream.of(extensionType), Arrays.stream(extensionType.getInterfaces()), Arrays.stream(extraTypes)).flatMap(Function.identity()).distinct().toArray(Class[]::new);
        return Proxy.newProxyInstance(extensionType.getClassLoader(), types, handler);
    }

    private static Object invoke(Object target, Method method, Object[] args) {
        if (Proxy.isProxyClass(target.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(target);
            return Unchecked.function(params -> handler.invoke(target, method, (Object[])params)).apply(args);
        }
        MethodHandle handle = Unchecked.function(MethodHandles.lookup()::unreflect).apply(method).bindTo(target);
        return Unchecked.function(handle::invokeWithArguments).apply(args);
    }

    @Override
    public OnDemandExtensions createCopy() {
        return new OnDemandExtensions(this);
    }

    static {
        try {
            EQUALS_METHOD = Object.class.getMethod("equals", Object.class);
            HASHCODE_METHOD = Object.class.getMethod("hashCode", new Class[0]);
            TOSTRING_METHOD = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException wat) {
            throw new IllegalStateException("OnDemandExtensions initialization failed", wat);
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public Optional<Object> onDemand(Jdbi var1, Class<?> var2, Class<?> ... var3);
    }
}

