/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.cache.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.GuardedBy;
import org.jdbi.v3.core.cache.JdbiCache;
import org.jdbi.v3.core.cache.JdbiCacheLoader;
import org.jdbi.v3.core.cache.internal.DefaultJdbiCacheBuilder;
import org.jdbi.v3.core.cache.internal.DefaultJdbiCacheStats;
import org.jdbi.v3.core.cache.internal.DoubleLinkedList;

final class DefaultJdbiCache<K, V>
implements JdbiCache<K, V> {
    private final ConcurrentMap<K, DoubleLinkedList.Node<K, V>> cache = new ConcurrentHashMap<K, DoubleLinkedList.Node<K, V>>();
    @GuardedBy(value="expungeQueue")
    private final DoubleLinkedList<K, V> expungeQueue = new DoubleLinkedList();
    private final JdbiCacheLoader<K, DoubleLinkedList.Node<K, V>> cacheLoader;
    private final int maxSize;

    DefaultJdbiCache(DefaultJdbiCacheBuilder builder, JdbiCacheLoader<K, V> cacheLoader) {
        this.cacheLoader = this.wrapLoader(cacheLoader);
        this.maxSize = builder.getMaxSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        try {
            DoubleLinkedList.Node node = this.cache.computeIfAbsent(key, this.cacheLoader::create);
            this.refresh(node);
            Object v = node.value;
            return v;
        }
        finally {
            this.expunge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getWithLoader(K key, JdbiCacheLoader<K, V> loader) {
        try {
            DoubleLinkedList.Node node = this.cache.computeIfAbsent(key, this.wrapLoader(loader)::create);
            this.refresh(node);
            Object v = node.value;
            return v;
        }
        finally {
            this.expunge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultJdbiCacheStats getStats() {
        DoubleLinkedList<K, V> doubleLinkedList = this.expungeQueue;
        synchronized (doubleLinkedList) {
            return new DefaultJdbiCacheStats(this.expungeQueue.size, this.maxSize);
        }
    }

    private JdbiCacheLoader<K, DoubleLinkedList.Node<K, V>> wrapLoader(JdbiCacheLoader<K, V> delegate) {
        if (delegate == null) {
            return k -> DoubleLinkedList.createNode(k, null);
        }
        return key -> {
            Object value = delegate.create(key);
            DoubleLinkedList.Node node = DoubleLinkedList.createNode(key, value);
            if (this.maxSize > 0) {
                DoubleLinkedList<K, V> doubleLinkedList = this.expungeQueue;
                synchronized (doubleLinkedList) {
                    this.expungeQueue.addHead(node);
                }
            }
            return node;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(DoubleLinkedList.Node<K, V> node) {
        if (this.maxSize > 0) {
            DoubleLinkedList<K, V> doubleLinkedList = this.expungeQueue;
            synchronized (doubleLinkedList) {
                DoubleLinkedList.Node<K, V> cacheNode = this.expungeQueue.removeNode(node);
                if (cacheNode != null) {
                    this.expungeQueue.addHead(cacheNode);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expunge() {
        DoubleLinkedList<K, V> doubleLinkedList = this.expungeQueue;
        synchronized (doubleLinkedList) {
            if (this.maxSize <= 0 || this.expungeQueue.size <= this.maxSize) {
                return;
            }
            while (this.expungeQueue.size > this.maxSize) {
                DoubleLinkedList.Node<K, V> node = this.expungeQueue.removeTail();
                if (node != null) {
                    this.cache.remove(node.key);
                    continue;
                }
                this.cache.clear();
            }
        }
    }
}

