/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ExtensionContext;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.internal.MemoizingSupplier;
import org.jdbi.v3.core.internal.OnDemandHandleSupplier;

class LazyHandleSupplier
implements HandleSupplier,
OnDemandHandleSupplier {
    private final Jdbi db;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Deque<ExtensionContext> extensionContexts = new LinkedList<ExtensionContext>();
    private final MemoizingSupplier<Handle> handleHolder = MemoizingSupplier.of(this::createHandle);

    LazyHandleSupplier(Jdbi db) {
        this.db = db;
    }

    @Override
    public ConfigRegistry getConfig() {
        ExtensionContext extensionContext = this.extensionContexts.peek();
        if (extensionContext != null) {
            return extensionContext.getConfig();
        }
        return this.db.getConfig();
    }

    @Override
    public Jdbi getJdbi() {
        return this.db;
    }

    @Override
    public Handle getHandle() {
        return this.handleHolder.get();
    }

    private Handle createHandle() {
        if (this.closed.get()) {
            throw new IllegalStateException("Handle is closed");
        }
        return this.db.open().acceptExtensionContext(this.extensionContexts.peek());
    }

    @Override
    public <V> V invokeInContext(ExtensionMethod extensionMethod, ConfigRegistry config, Callable<V> task) throws Exception {
        return this.invokeInContext(new ExtensionContext(config, extensionMethod), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V invokeInContext(ExtensionContext extensionContext, Callable<V> task) throws Exception {
        try {
            this.pushExtensionContext(extensionContext);
            V v = task.call();
            return v;
        }
        finally {
            this.popExtensionContext();
        }
    }

    private void pushExtensionContext(ExtensionContext extensionContext) {
        this.extensionContexts.addFirst(extensionContext);
        this.handleHolder.ifInitialized(h -> h.acceptExtensionContext(extensionContext));
    }

    private void popExtensionContext() {
        this.extensionContexts.pollFirst();
        this.handleHolder.ifInitialized(h -> h.acceptExtensionContext(this.extensionContexts.peek()));
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            throw new IllegalStateException("Handle is closed");
        }
        this.handleHolder.ifInitialized(Handle::close);
        this.extensionContexts.clear();
    }
}

