/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import org.jdbi.v3.core.CloseException;
import org.jdbi.v3.core.ConstantHandleSupplier;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.HandleConsumer;
import org.jdbi.v3.core.Handles;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.Configurable;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.extension.NoSuchExtensionException;
import org.jdbi.v3.core.statement.Batch;
import org.jdbi.v3.core.statement.Call;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Script;
import org.jdbi.v3.core.statement.StatementBuilder;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.core.transaction.TransactionException;
import org.jdbi.v3.core.transaction.TransactionHandler;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.core.transaction.UnableToManipulateTransactionIsolationLevelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handle
implements Closeable,
Configurable<Handle> {
    private static final Logger LOG = LoggerFactory.getLogger(Handle.class);
    private final TransactionHandler transactions;
    private final Connection connection;
    private final boolean forceEndTransactions;
    private ThreadLocal<ConfigRegistry> config;
    private ThreadLocal<ExtensionMethod> extensionMethod;
    private StatementBuilder statementBuilder;
    private boolean closed = false;

    Handle(ConfigRegistry config, TransactionHandler transactions, StatementBuilder statementBuilder, Connection connection) {
        this.transactions = transactions;
        this.connection = connection;
        this.config = ThreadLocal.withInitial(() -> config);
        this.extensionMethod = new ThreadLocal();
        this.statementBuilder = statementBuilder;
        this.forceEndTransactions = !transactions.isInTransaction(this);
    }

    @Override
    public ConfigRegistry getConfig() {
        return this.config.get();
    }

    void setConfig(ConfigRegistry config) {
        this.config.set(config);
    }

    void setConfigThreadLocal(ThreadLocal<ConfigRegistry> config) {
        this.config = config;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public StatementBuilder getStatementBuilder() {
        return this.statementBuilder;
    }

    public Handle setStatementBuilder(StatementBuilder builder) {
        this.statementBuilder = builder;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            boolean wasInTransaction = this.isInTransaction() && this.forceEndTransactions && this.config.get().get(Handles.class).isForceEndTransactions();
            this.extensionMethod.remove();
            this.config.remove();
            if (wasInTransaction) {
                this.rollback();
            }
            try {
                this.statementBuilder.close(this.getConnection());
            }
            finally {
                try {
                    this.connection.close();
                    if (wasInTransaction) {
                        throw new TransactionException("Improper transaction handling detected: A Handle with an open transaction was closed. Transactions must be explicitly committed or rolled back before closing the Handle. Jdbi has rolled back this transaction automatically. This check may be disabled by calling getConfig(Handles.class).setForceEndTransactions(false).");
                    }
                }
                catch (SQLException e) {
                    throw new CloseException("Unable to close Connection", e);
                }
                finally {
                    LOG.trace("Handle [{}] released", (Object)this);
                    this.closed = true;
                }
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Query select(String sql, Object ... args) {
        Query query = this.createQuery(sql);
        int position = 0;
        for (Object arg : args) {
            query.bind(position++, arg);
        }
        return query;
    }

    public int execute(String sql, Object ... args) {
        Update stmt = this.createUpdate(sql);
        int position = 0;
        for (Object arg : args) {
            stmt.bind(position++, arg);
        }
        return stmt.execute();
    }

    public Batch createBatch() {
        return new Batch(this);
    }

    public PreparedBatch prepareBatch(String sql) {
        return new PreparedBatch(this, sql);
    }

    public Call createCall(String sql) {
        return new Call(this, sql);
    }

    public Query createQuery(String sql) {
        return new Query(this, sql);
    }

    public Script createScript(String sql) {
        return new Script(this, sql);
    }

    public Update createUpdate(String sql) {
        return new Update(this, sql);
    }

    public boolean isInTransaction() {
        return this.transactions.isInTransaction(this);
    }

    public Handle begin() {
        this.transactions.begin(this);
        LOG.trace("Handle [{}] begin transaction", (Object)this);
        return this;
    }

    public Handle commit() {
        long start = System.nanoTime();
        this.transactions.commit(this);
        LOG.trace("Handle [{}] commit transaction in {}ms", (Object)this, (Object)((System.nanoTime() - start) / 1000000L));
        return this;
    }

    public Handle rollback() {
        long start = System.nanoTime();
        this.transactions.rollback(this);
        LOG.trace("Handle [{}] rollback transaction in {}ms", (Object)this, (Object)((System.nanoTime() - start) / 1000000L));
        return this;
    }

    public Handle rollbackToSavepoint(String savepointName) {
        long start = System.nanoTime();
        this.transactions.rollbackToSavepoint(this, savepointName);
        LOG.trace("Handle [{}] rollback to savepoint \"{}\" in {}ms", new Object[]{this, savepointName, (System.nanoTime() - start) / 1000000L});
        return this;
    }

    public Handle savepoint(String name) {
        this.transactions.savepoint(this, name);
        LOG.trace("Handle [{}] savepoint \"{}\"", (Object)this, (Object)name);
        return this;
    }

    public Handle release(String savepointName) {
        this.transactions.releaseSavepoint(this, savepointName);
        LOG.trace("Handle [{}] release savepoint \"{}\"", (Object)this, (Object)savepointName);
        return this;
    }

    public boolean isReadOnly() {
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException e) {
            throw new UnableToManipulateTransactionIsolationLevelException("Could not getReadOnly", e);
        }
    }

    public Handle setReadOnly(boolean readOnly) {
        try {
            this.connection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw new UnableToManipulateTransactionIsolationLevelException("Could not setReadOnly", e);
        }
        return this;
    }

    public <R, X extends Exception> R inTransaction(HandleCallback<R, X> callback) throws X {
        return this.transactions.inTransaction(this, callback);
    }

    public <X extends Exception> void useTransaction(HandleConsumer<X> callback) throws X {
        this.transactions.inTransaction(this, (Handle handle) -> {
            callback.useHandle(handle);
            return null;
        });
    }

    public <R, X extends Exception> R inTransaction(TransactionIsolationLevel level, HandleCallback<R, X> callback) throws X {
        try (TransactionResetter tr = new TransactionResetter(this.getTransactionIsolationLevel());){
            this.setTransactionIsolation(level);
            R r = this.transactions.inTransaction(this, level, callback);
            return r;
        }
    }

    public <X extends Exception> void useTransaction(TransactionIsolationLevel level, HandleConsumer<X> callback) throws X {
        this.inTransaction(level, handle -> {
            callback.useHandle(handle);
            return null;
        });
    }

    public void setTransactionIsolation(TransactionIsolationLevel level) {
        this.setTransactionIsolation(level.intValue());
    }

    public void setTransactionIsolation(int level) {
        try {
            if (this.connection.getTransactionIsolation() == level) {
                return;
            }
            this.connection.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            throw new UnableToManipulateTransactionIsolationLevelException(level, e);
        }
    }

    public TransactionIsolationLevel getTransactionIsolationLevel() {
        try {
            return TransactionIsolationLevel.valueOf(this.connection.getTransactionIsolation());
        }
        catch (SQLException e) {
            throw new UnableToManipulateTransactionIsolationLevelException("unable to access current setting", e);
        }
    }

    public <T> T attach(Class<T> extensionType) {
        return this.getConfig(Extensions.class).findFor(extensionType, ConstantHandleSupplier.of(this)).orElseThrow(() -> new NoSuchExtensionException("Extension not found: " + extensionType));
    }

    public ExtensionMethod getExtensionMethod() {
        return this.extensionMethod.get();
    }

    void setExtensionMethod(ExtensionMethod extensionMethod) {
        this.extensionMethod.set(extensionMethod);
    }

    void setExtensionMethodThreadLocal(ThreadLocal<ExtensionMethod> extensionMethod) {
        this.extensionMethod = Objects.requireNonNull(extensionMethod);
    }

    private class TransactionResetter
    implements Closeable {
        private final TransactionIsolationLevel initial;

        TransactionResetter(TransactionIsolationLevel initial) {
            this.initial = initial;
        }

        @Override
        public void close() {
            Handle.this.setTransactionIsolation(this.initial);
        }
    }
}

