/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.sql.SQLException;
import java.time.Instant;
import org.jdbi.v3.core.statement.SqlLoggable;
import org.jdbi.v3.core.statement.StatementContext;

public interface SqlLogger {
    public static final SqlLogger NOP_SQL_LOGGER = new SqlLogger(){};

    default public void logBeforeExecution(StatementContext context) {
    }

    default public void logAfterExecution(StatementContext context) {
    }

    default public void logException(StatementContext context, SQLException ex) {
    }

    default public <T> T wrap(SqlLoggable<T> r, StatementContext ctx) throws SQLException {
        try {
            ctx.setExecutionMoment(Instant.now());
            this.logBeforeExecution(ctx);
            T result = r.invoke();
            ctx.setCompletionMoment(Instant.now());
            this.logAfterExecution(ctx);
            return result;
        }
        catch (SQLException e) {
            ctx.setExceptionMoment(Instant.now());
            this.logException(ctx, e);
            throw e;
        }
    }
}

