/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.NamedArgumentFinder;
import org.jdbi.v3.core.internal.JdbiStreams;
import org.jdbi.v3.core.statement.StatementContext;

public class Binding {
    private final Map<Integer, Argument> positionals = new HashMap<Integer, Argument>();
    private final Map<String, Argument> named = new HashMap<String, Argument>();
    private final List<NamedArgumentFinder> namedArgumentFinder = new ArrayList<NamedArgumentFinder>();

    public void addPositional(int position, Argument argument) {
        this.positionals.put(position, argument);
    }

    public void addNamed(String name, Argument argument) {
        this.named.put(name, argument);
    }

    public void addNamedArgumentFinder(NamedArgumentFinder args) {
        this.namedArgumentFinder.add(args);
    }

    public Optional<Argument> findForName(String name, StatementContext ctx) {
        if (this.named.containsKey(name)) {
            return Optional.of(this.named.get(name));
        }
        return this.namedArgumentFinder.stream().flatMap(arguments -> JdbiStreams.toStream(arguments.find(name, ctx))).findFirst();
    }

    public Optional<Argument> findForPosition(int position) {
        return Optional.ofNullable(this.positionals.get(position));
    }

    public String toString() {
        boolean wrote = false;
        StringBuilder b = new StringBuilder();
        b.append("{ positional:{");
        for (Map.Entry<Integer, Argument> entry : this.positionals.entrySet()) {
            wrote = true;
            b.append(entry.getKey()).append(":").append(entry.getValue()).append(",");
        }
        if (wrote) {
            wrote = false;
            b.deleteCharAt(b.length() - 1);
        }
        b.append("}");
        b.append(", named:{");
        for (Map.Entry<Object, Argument> entry : this.named.entrySet()) {
            wrote = true;
            b.append((String)entry.getKey()).append(":").append(entry.getValue()).append(",");
        }
        if (wrote) {
            wrote = false;
            b.deleteCharAt(b.length() - 1);
        }
        b.append("}");
        b.append(", finder:[");
        for (NamedArgumentFinder namedArgumentFinder : this.namedArgumentFinder) {
            wrote = true;
            b.append(namedArgumentFinder).append(",");
        }
        if (wrote) {
            b.deleteCharAt(b.length() - 1);
        }
        b.append("]");
        b.append("}");
        return b.toString();
    }

    public void clear() {
        this.positionals.clear();
        this.named.clear();
        this.namedArgumentFinder.clear();
    }

    public boolean isEmpty() {
        return this.positionals.isEmpty() && this.named.isEmpty() && this.namedArgumentFinder.isEmpty();
    }
}

