/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.mapper.EnumMapper;
import org.jdbi.v3.core.mapper.MappingException;
import org.jdbi.v3.core.mapper.OptionalMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class BuiltInMapperFactory
implements ColumnMapperFactory {
    private static final Map<Class<?>, ColumnMapper<?>> MAPPERS = new HashMap();

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        Class<?> rawType = GenericTypes.getErasedType(type);
        if (rawType.isEnum()) {
            return Optional.of(EnumMapper.byName(rawType.asSubclass(Enum.class)));
        }
        if (rawType == Optional.class) {
            return Optional.of(OptionalMapper.of(type));
        }
        return Optional.ofNullable(MAPPERS.get(rawType));
    }

    private static <T> ColumnMapper<T> primitiveMapper(ColumnGetter<T> getter) {
        return (r, i, ctx) -> getter.get(r, i);
    }

    private static <T> ColumnMapper<T> referenceMapper(ColumnGetter<T> getter) {
        return (r, i, ctx) -> {
            Object value = getter.get(r, i);
            return r.wasNull() ? null : value;
        };
    }

    private static char getChar(ResultSet r, int i) throws SQLException {
        Character character = BuiltInMapperFactory.getCharacter(r, i);
        return character == null ? (char)'\u0000' : character.charValue();
    }

    private static Character getCharacter(ResultSet r, int i) throws SQLException {
        String s = r.getString(i);
        if (s != null && !s.isEmpty()) {
            return Character.valueOf(s.charAt(0));
        }
        return null;
    }

    private static URI getURI(ResultSet r, int i) throws SQLException {
        String s = r.getString(i);
        try {
            return s != null ? new URI(s) : null;
        }
        catch (URISyntaxException e) {
            throw new SQLException("Failed to convert data to URI", e);
        }
    }

    private static UUID getUUID(ResultSet r, int i, StatementContext ctx) throws SQLException {
        String s = r.getString(i);
        if (s == null) {
            return null;
        }
        return UUID.fromString(s);
    }

    private static Instant getInstant(ResultSet r, int i) throws SQLException {
        Timestamp ts = r.getTimestamp(i);
        return ts == null ? null : ts.toInstant();
    }

    private static LocalDate getLocalDate(ResultSet r, int i) throws SQLException {
        Timestamp ts = r.getTimestamp(i);
        return ts == null ? null : ts.toLocalDateTime().toLocalDate();
    }

    private static LocalDateTime getLocalDateTime(ResultSet r, int i) throws SQLException {
        Timestamp ts = r.getTimestamp(i);
        return ts == null ? null : ts.toLocalDateTime();
    }

    private static OffsetDateTime getOffsetDateTime(ResultSet r, int i) throws SQLException {
        Timestamp ts = r.getTimestamp(i);
        return ts == null ? null : OffsetDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault());
    }

    private static ZonedDateTime getZonedDateTime(ResultSet r, int i) throws SQLException {
        Timestamp ts = r.getTimestamp(i);
        return ts == null ? null : ZonedDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault());
    }

    private static LocalTime getLocalTime(ResultSet r, int i) throws SQLException {
        Time time = r.getTime(i);
        return time == null ? null : time.toLocalTime();
    }

    private static ZoneId getZoneId(ResultSet r, int i) throws SQLException {
        String id = r.getString(i);
        return id == null ? null : ZoneId.of(id);
    }

    private static InetAddress getInetAddress(ResultSet r, int i, StatementContext ctx) throws SQLException {
        String hostname = r.getString(i);
        try {
            return hostname == null ? null : InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            throw new MappingException("Could not map InetAddress", e);
        }
    }

    private static <Opt, Box> ColumnMapper<?> optionalMapper(final ColumnGetter<Box> columnGetter, final Supplier<Opt> empty, final Function<Box, Opt> present) {
        return new ColumnMapper<Opt>(){

            @Override
            public Opt map(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
                Object boxed = BuiltInMapperFactory.referenceMapper(columnGetter).map(r, columnNumber, ctx);
                if (boxed == null) {
                    return empty.get();
                }
                return present.apply(boxed);
            }
        };
    }

    static {
        MAPPERS.put(Boolean.TYPE, BuiltInMapperFactory.primitiveMapper(ResultSet::getBoolean));
        MAPPERS.put(Byte.TYPE, BuiltInMapperFactory.primitiveMapper(ResultSet::getByte));
        MAPPERS.put(Character.TYPE, BuiltInMapperFactory.primitiveMapper(BuiltInMapperFactory::getChar));
        MAPPERS.put(Short.TYPE, BuiltInMapperFactory.primitiveMapper(ResultSet::getShort));
        MAPPERS.put(Integer.TYPE, BuiltInMapperFactory.primitiveMapper(ResultSet::getInt));
        MAPPERS.put(Long.TYPE, BuiltInMapperFactory.primitiveMapper(ResultSet::getLong));
        MAPPERS.put(Float.TYPE, BuiltInMapperFactory.primitiveMapper(ResultSet::getFloat));
        MAPPERS.put(Double.TYPE, BuiltInMapperFactory.primitiveMapper(ResultSet::getDouble));
        MAPPERS.put(Boolean.class, BuiltInMapperFactory.referenceMapper(ResultSet::getBoolean));
        MAPPERS.put(Byte.class, BuiltInMapperFactory.referenceMapper(ResultSet::getByte));
        MAPPERS.put(Character.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getCharacter));
        MAPPERS.put(Short.class, BuiltInMapperFactory.referenceMapper(ResultSet::getShort));
        MAPPERS.put(Integer.class, BuiltInMapperFactory.referenceMapper(ResultSet::getInt));
        MAPPERS.put(Long.class, BuiltInMapperFactory.referenceMapper(ResultSet::getLong));
        MAPPERS.put(Float.class, BuiltInMapperFactory.referenceMapper(ResultSet::getFloat));
        MAPPERS.put(Double.class, BuiltInMapperFactory.referenceMapper(ResultSet::getDouble));
        MAPPERS.put(BigDecimal.class, BuiltInMapperFactory.referenceMapper(ResultSet::getBigDecimal));
        MAPPERS.put(String.class, BuiltInMapperFactory.referenceMapper(ResultSet::getString));
        MAPPERS.put(byte[].class, BuiltInMapperFactory.referenceMapper(ResultSet::getBytes));
        MAPPERS.put(Timestamp.class, BuiltInMapperFactory.referenceMapper(ResultSet::getTimestamp));
        MAPPERS.put(InetAddress.class, BuiltInMapperFactory::getInetAddress);
        MAPPERS.put(URL.class, BuiltInMapperFactory.referenceMapper(ResultSet::getURL));
        MAPPERS.put(URI.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getURI));
        MAPPERS.put(UUID.class, BuiltInMapperFactory::getUUID);
        MAPPERS.put(Instant.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getInstant));
        MAPPERS.put(LocalDate.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getLocalDate));
        MAPPERS.put(LocalDateTime.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getLocalDateTime));
        MAPPERS.put(OffsetDateTime.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getOffsetDateTime));
        MAPPERS.put(ZonedDateTime.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getZonedDateTime));
        MAPPERS.put(LocalTime.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getLocalTime));
        MAPPERS.put(ZoneId.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getZoneId));
        MAPPERS.put(OptionalInt.class, BuiltInMapperFactory.optionalMapper(ResultSet::getInt, OptionalInt::empty, OptionalInt::of));
        MAPPERS.put(OptionalLong.class, BuiltInMapperFactory.optionalMapper(ResultSet::getLong, OptionalLong::empty, OptionalLong::of));
        MAPPERS.put(OptionalDouble.class, BuiltInMapperFactory.optionalMapper(ResultSet::getDouble, OptionalDouble::empty, OptionalDouble::of));
    }

    @FunctionalInterface
    static interface ColumnGetter<T> {
        public T get(ResultSet var1, int var2) throws SQLException;
    }
}

