/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument.internal;

import java.util.Collection;
import java.util.Optional;
import org.jdbi.v3.core.argument.NamedArgumentFinder;
import org.jdbi.v3.core.argument.internal.ObjectPropertyNamedArgumentFinder;
import org.jdbi.v3.core.argument.internal.TypedValue;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.reflect.internal.PojoProperties;
import org.jdbi.v3.core.mapper.reflect.internal.PojoTypes;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;

public class PojoPropertyArguments
extends ObjectPropertyNamedArgumentFinder {
    protected final PojoProperties<?> properties;
    protected final ConfigRegistry config;

    public PojoPropertyArguments(String prefix, Object obj, ConfigRegistry config) {
        this(prefix, obj, config.get(PojoTypes.class).findFor(obj.getClass()).orElseThrow(() -> new UnableToCreateStatementException("Couldn't find pojo type of " + obj.getClass())), config);
    }

    protected PojoPropertyArguments(String prefix, Object obj, PojoProperties<?> properties, ConfigRegistry config) {
        super(prefix, obj);
        this.properties = properties;
        this.config = config;
    }

    @Override
    protected Optional<TypedValue> getValue(String name, StatementContext ctx) {
        return Optional.ofNullable(this.properties.getProperties().get(name)).map(PojoProperties.PojoProperty.class::cast).map(p -> new TypedValue(p.getQualifiedType(), p.get(this.obj)));
    }

    @Override
    public Collection<String> getNames() {
        return this.properties.getProperties().keySet();
    }

    @Override
    protected NamedArgumentFinder getNestedArgumentFinder(Object o) {
        return new PojoPropertyArguments(null, o, this.config);
    }

    public String toString() {
        return "{lazy bean property arguments \"" + this.obj + "\"}";
    }
}

