/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.transaction.TransactionException;
import org.jdbi.v3.core.transaction.TransactionHandler;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.core.transaction.UnableToRestoreAutoCommitStateException;

public class LocalTransactionHandler
implements TransactionHandler {
    private final ConcurrentHashMap<Handle, LocalStuff> localStuff = new ConcurrentHashMap();
    private final ThreadLocal<Boolean> didTxnRollback = ThreadLocal.withInitial(() -> false);

    @Override
    public void begin(Handle handle) {
        try {
            if (!this.localStuff.containsKey(handle)) {
                boolean initial = handle.getConnection().getAutoCommit();
                this.localStuff.putIfAbsent(handle, new LocalStuff(initial));
                handle.getConnection().setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new TransactionException("Failed to start transaction", e);
        }
    }

    @Override
    public void commit(Handle handle) {
        try {
            handle.getConnection().commit();
        }
        catch (SQLException e) {
            throw new TransactionException("Failed to commit transaction", e);
        }
        finally {
            this.restoreAutoCommitState(handle);
        }
    }

    @Override
    public void rollback(Handle handle) {
        this.didTxnRollback.set(true);
        try {
            handle.getConnection().rollback();
        }
        catch (SQLException e) {
            throw new TransactionException("Failed to rollback transaction", e);
        }
        finally {
            this.restoreAutoCommitState(handle);
        }
    }

    @Override
    public void savepoint(Handle handle, String name) {
        Connection conn = handle.getConnection();
        try {
            Savepoint savepoint = conn.setSavepoint(name);
            this.localStuff.get(handle).getSavepoints().put(name, savepoint);
        }
        catch (SQLException e) {
            throw new TransactionException(String.format("Unable to create savepoint '%s'", name), e);
        }
    }

    @Override
    public void releaseSavepoint(Handle handle, String name) {
        Connection conn = handle.getConnection();
        try {
            Savepoint savepoint = this.localStuff.get(handle).getSavepoints().remove(name);
            if (savepoint == null) {
                throw new TransactionException(String.format("Attempt to release non-existent savepoint, '%s'", name));
            }
            conn.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            throw new TransactionException(String.format("Unable to create savepoint %s", name), e);
        }
    }

    @Override
    public void rollbackToSavepoint(Handle handle, String name) {
        Connection conn = handle.getConnection();
        try {
            Savepoint savepoint = this.localStuff.get(handle).getSavepoints().remove(name);
            if (savepoint == null) {
                throw new TransactionException(String.format("Attempt to rollback to non-existent savepoint, '%s'", name));
            }
            conn.rollback(savepoint);
        }
        catch (SQLException e) {
            throw new TransactionException(String.format("Unable to create savepoint %s", name), e);
        }
    }

    @Override
    public boolean isInTransaction(Handle handle) {
        try {
            return !handle.getConnection().getAutoCommit();
        }
        catch (SQLException e) {
            throw new TransactionException("Failed to test for transaction status", e);
        }
    }

    @Override
    public <R, X extends Exception> R inTransaction(Handle handle, HandleCallback<R, X> callback) throws X {
        R returnValue;
        if (this.isInTransaction(handle)) {
            throw new IllegalStateException("Already in transaction");
        }
        this.didTxnRollback.set(false);
        try {
            handle.begin();
            returnValue = callback.withHandle(handle);
            if (!this.didTxnRollback.get().booleanValue()) {
                handle.commit();
            }
        }
        catch (Throwable e) {
            try {
                handle.rollback();
            }
            catch (Exception rollback) {
                e.addSuppressed(rollback);
            }
            throw e;
        }
        this.didTxnRollback.remove();
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R, X extends Exception> R inTransaction(Handle handle, TransactionIsolationLevel level, HandleCallback<R, X> callback) throws X {
        TransactionIsolationLevel initial = handle.getTransactionIsolationLevel();
        try {
            handle.setTransactionIsolation(level);
            R r = this.inTransaction(handle, callback);
            return r;
        }
        finally {
            handle.setTransactionIsolation(initial);
        }
    }

    private void restoreAutoCommitState(Handle handle) {
        try {
            LocalStuff stuff = this.localStuff.remove(handle);
            if (stuff != null) {
                handle.getConnection().setAutoCommit(stuff.getInitialAutocommit());
                stuff.getSavepoints().clear();
            }
        }
        catch (SQLException e) {
            throw new UnableToRestoreAutoCommitStateException(e);
        }
        finally {
            this.localStuff.remove(handle);
        }
    }

    private static class LocalStuff {
        private final Map<String, Savepoint> savepoints = new HashMap<String, Savepoint>();
        private final boolean initialAutocommit;

        LocalStuff(boolean initial) {
            this.initialAutocommit = initial;
        }

        Map<String, Savepoint> getSavepoints() {
            return this.savepoints;
        }

        boolean getInitialAutocommit() {
            return this.initialAutocommit;
        }
    }
}

