/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect.internal;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiCache;
import org.jdbi.v3.core.config.JdbiCaches;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.internal.exceptions.CheckedBiConsumer;
import org.jdbi.v3.core.internal.exceptions.CheckedFunction;
import org.jdbi.v3.core.internal.exceptions.Sneaky;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.mapper.reflect.internal.PojoProperties;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.qualifier.Qualifiers;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;

public class BeanPropertiesFactory {
    private static final JdbiCache<Type, BeanPojoProperties.PropertiesHolder<?>> PROPERTY_CACHE = JdbiCaches.declare(t -> new BeanPojoProperties.PropertiesHolder(GenericTypes.getErasedType(t)));

    private BeanPropertiesFactory() {
    }

    public static PojoProperties<?> propertiesFor(Type t, ConfigRegistry config) {
        return new BeanPojoProperties(t, config);
    }

    private static boolean shouldSeeProperty(PropertyDescriptor pd) {
        Method read = pd.getReadMethod();
        return read == null || read.getDeclaringClass() != Object.class;
    }

    static class BeanPojoProperties<T>
    extends PojoProperties<T> {
        private final ConfigRegistry config;

        BeanPojoProperties(Type type, ConfigRegistry config) {
            super(type);
            this.config = config;
        }

        @Override
        public Map<String, BeanPojoProperty<T>> getProperties() {
            return ((PropertiesHolder)PROPERTY_CACHE.get(this.getType(), (ConfigRegistry)this.config)).properties;
        }

        @Override
        public PojoProperties.PojoBuilder<T> create() {
            final PropertiesHolder holder = (PropertiesHolder)PROPERTY_CACHE.get(this.getType(), this.config);
            final Object instance = holder.constructor.get();
            return new PojoProperties.PojoBuilder<T>(){

                @Override
                public void set(String property, Object value) {
                    holder.properties.get(property).setter().accept(instance, value);
                }

                @Override
                public T build() {
                    return instance;
                }
            };
        }

        static class PropertiesHolder<T> {
            final Supplier<T> constructor;
            final Map<String, BeanPojoProperty<?>> properties;

            PropertiesHolder(Class<?> clazz) {
                Supplier<Object> myConstructor;
                try {
                    this.properties = Arrays.stream(Introspector.getBeanInfo(clazz).getPropertyDescriptors()).filter(x$0 -> BeanPropertiesFactory.shouldSeeProperty(x$0)).map(BeanPojoProperty::new).collect(Collectors.toMap(PojoProperties.PojoProperty::getName, Function.identity()));
                }
                catch (IntrospectionException e) {
                    throw new IllegalArgumentException("Failed to inspect bean " + clazz, e);
                }
                try {
                    MethodHandle ctorMh = MethodHandles.lookup().findConstructor(clazz, MethodType.methodType(Void.TYPE)).asType(MethodType.methodType(clazz));
                    myConstructor = Unchecked.supplier(() -> ctorMh.invoke());
                }
                catch (ReflectiveOperationException e) {
                    myConstructor = () -> {
                        throw Sneaky.throwAnyway(e);
                    };
                }
                this.constructor = myConstructor;
            }
        }

        static class BeanPojoProperty<T>
        implements PojoProperties.PojoProperty<T> {
            final PropertyDescriptor descriptor;
            final QualifiedType<?> qualifiedType;
            final ConcurrentMap<Class<?>, Optional<Annotation>> annoCache = new ConcurrentHashMap();
            final Function<Object, Object> getter;
            final BiConsumer<Object, Object> setter;

            BeanPojoProperty(PropertyDescriptor property) {
                this.descriptor = property;
                this.qualifiedType = this.determineQualifiedType();
                this.getter = Optional.ofNullable(this.descriptor.getReadMethod()).map(Unchecked.function(MethodHandles.lookup()::unreflect)).map(mh -> Unchecked.function((CheckedFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)mh))).orElse(null);
                this.setter = Optional.ofNullable(this.descriptor.getWriteMethod()).map(Unchecked.function(MethodHandles.lookup()::unreflect)).map(mh -> Unchecked.biConsumer((CheckedBiConsumer<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, invoke(java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)V)((MethodHandle)mh))).orElse(null);
            }

            protected Function<Object, Object> getter() {
                if (this.getter == null) {
                    throw new UnableToCreateStatementException(String.format("No getter method found for bean property [%s] on [%s]", this.getName(), this.qualifiedType));
                }
                return this.getter;
            }

            protected BiConsumer<Object, Object> setter() {
                if (this.setter == null) {
                    throw new UnableToCreateStatementException(String.format("No setter method found for bean property [%s] on [%s]", this.getName(), this.qualifiedType));
                }
                return this.setter;
            }

            @Override
            public String getName() {
                return this.descriptor.getName();
            }

            @Override
            public QualifiedType<?> getQualifiedType() {
                return this.qualifiedType;
            }

            private QualifiedType<?> determineQualifiedType() {
                Parameter setterParam = Optional.ofNullable(this.descriptor.getWriteMethod()).map(m -> m.getParameterCount() > 0 ? m.getParameters()[0] : null).orElse(null);
                return QualifiedType.of(Optional.ofNullable(this.descriptor.getReadMethod()).map(Method::getGenericReturnType).orElseGet(() -> this.descriptor.getWriteMethod().getGenericParameterTypes()[0])).withAnnotations(new Qualifiers().findFor(this.descriptor.getReadMethod(), this.descriptor.getWriteMethod(), setterParam));
            }

            @Override
            public <A extends Annotation> Optional<A> getAnnotation(Class<A> anno) {
                return this.annoCache.computeIfAbsent(anno, x -> Stream.of(this.descriptor.getReadMethod(), this.descriptor.getWriteMethod()).filter(Objects::nonNull).map(m -> m.getAnnotation(anno)).filter(Objects::nonNull).findFirst().map(Annotation.class::cast)).map(anno::cast);
            }

            @Override
            public Object get(T pojo) {
                return this.getter().apply(pojo);
            }
        }
    }
}

