/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.internal.JdbiOptionals;
import org.jdbi.v3.core.mapper.InferredRowMapperFactory;
import org.jdbi.v3.core.mapper.MapEntryMapper;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.core.mapper.reflect.internal.PojoMapperFactory;

public class RowMappers
implements JdbiConfig<RowMappers> {
    private final List<RowMapperFactory> factories = new CopyOnWriteArrayList<RowMapperFactory>();
    private final ConcurrentHashMap<Type, RowMapper<?>> cache = new ConcurrentHashMap();
    private ConfigRegistry registry;

    public RowMappers() {
        this.register(MapEntryMapper.factory());
        this.register(new PojoMapperFactory());
    }

    private RowMappers(RowMappers that) {
        this.factories.addAll(that.factories);
        this.cache.putAll(that.cache);
    }

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    public RowMappers register(RowMapper<?> mapper) {
        return this.register(new InferredRowMapperFactory(mapper));
    }

    public <T> RowMappers register(GenericType<T> type, RowMapper<T> mapper) {
        return this.register(RowMapperFactory.of(type.getType(), mapper));
    }

    public RowMappers register(Type type, RowMapper<?> mapper) {
        return this.register(RowMapperFactory.of(type, mapper));
    }

    public RowMappers register(RowMapperFactory factory) {
        this.factories.add(0, factory);
        this.cache.clear();
        return this;
    }

    public <T> Optional<RowMapper<T>> findFor(Class<T> type) {
        RowMapper mapper = this.findFor((Type)type).orElse(null);
        return Optional.ofNullable(mapper);
    }

    public <T> Optional<RowMapper<T>> findFor(GenericType<T> type) {
        RowMapper mapper = this.findFor(type.getType()).orElse(null);
        return Optional.ofNullable(mapper);
    }

    public Optional<RowMapper<?>> findFor(Type type) {
        RowMapper<?> cached = this.cache.get(type);
        if (cached != null) {
            return Optional.of(cached);
        }
        Optional<RowMapper<?>> mapper = this.factories.stream().flatMap(factory -> JdbiOptionals.stream(factory.build(type, this.registry))).findFirst();
        mapper.ifPresent(m -> this.cache.put(type, (RowMapper<?>)m));
        return mapper;
    }

    @Override
    public RowMappers createCopy() {
        return new RowMappers(this);
    }
}

