/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.io.Closeable;
import java.sql.SQLException;
import java.util.Collection;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.Configurable;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.statement.Cleanable;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementCustomizer;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;

abstract class BaseStatement<This>
implements Closeable,
Configurable<This> {
    final This typedThis = this;
    private final Handle handle;
    private final StatementContext ctx;

    BaseStatement(Handle handle) {
        this.handle = handle;
        this.ctx = new StatementContext(handle.getConfig().createCopy(), handle.getExtensionMethod());
        if (GenericTypes.findGenericParameter(this.getClass(), BaseStatement.class).map(GenericTypes::getErasedType).map(type -> !type.isAssignableFrom(this.getClass())).orElse(false).booleanValue()) {
            throw new IllegalStateException("inconsistent SqlStatement hierarchy");
        }
    }

    public Handle getHandle() {
        return this.handle;
    }

    @Override
    public ConfigRegistry getConfig() {
        return this.ctx.getConfig();
    }

    public final StatementContext getContext() {
        return this.ctx;
    }

    This addCleanable(Cleanable cleanable) {
        this.getContext().addCleanable(cleanable);
        return this.typedThis;
    }

    void addCustomizers(Collection<StatementCustomizer> customizers) {
        customizers.forEach(this::addCustomizer);
    }

    final void callCustomizers(StatementCustomizerInvocation invocation) {
        for (StatementCustomizer customizer : this.getCustomizers()) {
            try {
                invocation.call(customizer);
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException("Exception thrown in statement customization", e, this.ctx);
            }
        }
    }

    private Collection<StatementCustomizer> getCustomizers() {
        return this.getConfig(SqlStatements.class).getCustomizers();
    }

    @Override
    public void close() {
        this.getContext().close();
    }

    @FunctionalInterface
    static interface StatementCustomizerInvocation {
        public void call(StatementCustomizer var1) throws SQLException;
    }
}

