/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.extension;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.extension.ExtensionFactory;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.meta.Beta;

public class Extensions
implements JdbiConfig<Extensions> {
    private final List<ExtensionFactory> factories = new CopyOnWriteArrayList<ExtensionFactory>();
    private boolean allowProxy = true;

    public Extensions() {
    }

    private Extensions(Extensions that) {
        this.factories.addAll(that.factories);
    }

    public Extensions register(ExtensionFactory factory) {
        this.factories.add(0, factory);
        return this;
    }

    public boolean hasExtensionFor(Class<?> extensionType) {
        return this.findFactoryFor(extensionType).isPresent();
    }

    public <E> Optional<E> findFor(Class<E> extensionType, HandleSupplier handle) {
        return this.findFactoryFor(extensionType).map(factory -> factory.attach(extensionType, handle));
    }

    private Optional<ExtensionFactory> findFactoryFor(Class<?> extensionType) {
        return this.factories.stream().filter(factory -> factory.accepts(extensionType)).findFirst();
    }

    public <F extends ExtensionFactory> Optional<F> findFactory(Class<F> factoryType) {
        return this.factories.stream().filter(factoryType::isInstance).map(factoryType::cast).findFirst();
    }

    @Beta
    public Extensions setAllowProxy(boolean allowProxy) {
        this.allowProxy = allowProxy;
        return this;
    }

    @Beta
    public boolean isAllowProxy() {
        return this.allowProxy;
    }

    @Override
    public Extensions createCopy() {
        return new Extensions(this);
    }

    @Beta
    public void onCreateProxy() {
        if (!this.isAllowProxy()) {
            throw new IllegalStateException("Creating onDemand proxy disallowed. Ensure @GenerateSqlObject annotation is being processed by `jdbi3-generator` annotation processor.");
        }
    }
}

