/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.BoxedArgumentFactory;
import org.jdbi.v3.core.argument.EnumArgumentFactory;
import org.jdbi.v3.core.argument.EssentialsArgumentFactory;
import org.jdbi.v3.core.argument.InternetArgumentFactory;
import org.jdbi.v3.core.argument.JavaTimeArgumentFactory;
import org.jdbi.v3.core.argument.JavaTimeZoneIdArgumentFactory;
import org.jdbi.v3.core.argument.NVarcharArgumentFactory;
import org.jdbi.v3.core.argument.NullArgument;
import org.jdbi.v3.core.argument.OptionalArgumentFactory;
import org.jdbi.v3.core.argument.PrimitivesArgumentFactory;
import org.jdbi.v3.core.argument.QualifiedArgumentFactory;
import org.jdbi.v3.core.argument.SqlArgumentFactory;
import org.jdbi.v3.core.argument.SqlTimeArgumentFactory;
import org.jdbi.v3.core.argument.UntypedNullArgumentFactory;
import org.jdbi.v3.core.array.SqlArrayArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.internal.JdbiOptionals;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.meta.Beta;

public class Arguments
implements JdbiConfig<Arguments> {
    private final List<QualifiedArgumentFactory> factories = new CopyOnWriteArrayList<QualifiedArgumentFactory>();
    private ConfigRegistry registry;
    private Argument untypedNullArgument = new NullArgument(1111);

    public Arguments() {
        this.register(new UntypedNullArgumentFactory());
        this.register(new PrimitivesArgumentFactory());
        this.register(new BoxedArgumentFactory());
        this.register(new SqlArgumentFactory());
        this.register(new InternetArgumentFactory());
        this.register(new SqlTimeArgumentFactory());
        this.register(new JavaTimeArgumentFactory());
        this.register(new SqlArrayArgumentFactory());
        this.register(new EssentialsArgumentFactory());
        this.register(new JavaTimeZoneIdArgumentFactory());
        this.register(new NVarcharArgumentFactory());
        this.register(new EnumArgumentFactory());
        this.register(new OptionalArgumentFactory());
    }

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    private Arguments(Arguments that) {
        this.factories.addAll(that.factories);
        this.untypedNullArgument = that.untypedNullArgument;
    }

    public Arguments register(ArgumentFactory factory) {
        return this.register(QualifiedArgumentFactory.adapt(factory));
    }

    @Beta
    public Arguments register(QualifiedArgumentFactory factory) {
        this.factories.add(0, factory);
        return this;
    }

    public Optional<Argument> findFor(Type type, Object value) {
        return this.findFor(QualifiedType.of(type), value);
    }

    @Beta
    public Optional<Argument> findFor(QualifiedType<?> type, Object value) {
        return this.factories.stream().flatMap(factory -> JdbiOptionals.stream(factory.build(type, value, this.registry))).findFirst();
    }

    public void setUntypedNullArgument(Argument untypedNullArgument) {
        if (untypedNullArgument == null) {
            throw new IllegalArgumentException("the Argument itself may not be null");
        }
        this.untypedNullArgument = untypedNullArgument;
    }

    public Argument getUntypedNullArgument() {
        return this.untypedNullArgument;
    }

    @Override
    public Arguments createCopy() {
        return new Arguments(this);
    }
}

