/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jdbi.v3.core.CloseException;
import org.jdbi.v3.core.ConstantHandleSupplier;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.HandleConsumer;
import org.jdbi.v3.core.Handles;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.Configurable;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.extension.NoSuchExtensionException;
import org.jdbi.v3.core.statement.Batch;
import org.jdbi.v3.core.statement.Call;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Script;
import org.jdbi.v3.core.statement.StatementBuilder;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.core.transaction.TransactionException;
import org.jdbi.v3.core.transaction.TransactionHandler;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.core.transaction.UnableToManipulateTransactionIsolationLevelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handle
implements Closeable,
Configurable<Handle> {
    private static final Logger LOG = LoggerFactory.getLogger(Handle.class);
    private final Jdbi jdbi;
    private final ConnectionCloser closer;
    private final TransactionHandler transactions;
    private final Connection connection;
    private final boolean forceEndTransactions;
    private ThreadLocal<ConfigRegistry> localConfig;
    private ThreadLocal<ExtensionMethod> localExtensionMethod;
    private StatementBuilder statementBuilder;
    private boolean closed = false;

    Handle(Jdbi jdbi, ConfigRegistry localConfig, ConnectionCloser closer, TransactionHandler transactions, StatementBuilder statementBuilder, Connection connection) {
        this.jdbi = jdbi;
        this.closer = closer;
        this.transactions = transactions;
        this.connection = connection;
        this.localConfig = ThreadLocal.withInitial(() -> localConfig);
        this.localExtensionMethod = new ThreadLocal();
        this.statementBuilder = statementBuilder;
        this.forceEndTransactions = !transactions.isInTransaction(this);
    }

    public Jdbi getJdbi() {
        return this.jdbi;
    }

    @Override
    public ConfigRegistry getConfig() {
        return this.localConfig.get();
    }

    void setConfig(ConfigRegistry config) {
        this.localConfig.set(config);
    }

    void setLocalConfig(ThreadLocal<ConfigRegistry> configThreadLocal) {
        this.localConfig = configThreadLocal;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public StatementBuilder getStatementBuilder() {
        return this.statementBuilder;
    }

    public Handle setStatementBuilder(StatementBuilder builder) {
        this.statementBuilder = builder;
        return this;
    }

    @Override
    public void close() {
        ArrayList<Exception> suppressed = new ArrayList<Exception>();
        if (this.closed) {
            return;
        }
        boolean wasInTransaction = false;
        if (this.forceEndTransactions && this.localConfig.get().get(Handles.class).isForceEndTransactions()) {
            try {
                wasInTransaction = this.isInTransaction();
            }
            catch (Exception e) {
                suppressed.add(e);
            }
        }
        this.localExtensionMethod.remove();
        this.localConfig.remove();
        if (wasInTransaction) {
            try {
                this.rollback();
            }
            catch (Exception e) {
                suppressed.add(e);
            }
        }
        try {
            this.statementBuilder.close(this.getConnection());
        }
        catch (Exception e) {
            suppressed.add(e);
        }
        try {
            this.closer.close(this.connection);
            if (!suppressed.isEmpty()) {
                Throwable original = (Throwable)suppressed.remove(0);
                suppressed.forEach(original::addSuppressed);
                throw new CloseException("Failed to clear transaction status on close", original);
            }
            if (wasInTransaction) {
                throw new TransactionException("Improper transaction handling detected: A Handle with an open transaction was closed. Transactions must be explicitly committed or rolled back before closing the Handle. Jdbi has rolled back this transaction automatically. This check may be disabled by calling getConfig(Handles.class).setForceEndTransactions(false).");
            }
        }
        catch (SQLException e) {
            CloseException ce = new CloseException("Unable to close Connection", e);
            suppressed.forEach(ce::addSuppressed);
            throw ce;
        }
        finally {
            LOG.trace("Handle [{}] released", (Object)this);
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Query select(String sql, Object ... args) {
        Query query = this.createQuery(sql);
        int position = 0;
        for (Object arg : args) {
            query.bind(position++, arg);
        }
        return query;
    }

    public int execute(String sql, Object ... args) {
        Update stmt = this.createUpdate(sql);
        int position = 0;
        for (Object arg : args) {
            stmt.bind(position++, arg);
        }
        return stmt.execute();
    }

    public Batch createBatch() {
        return new Batch(this);
    }

    public PreparedBatch prepareBatch(String sql) {
        return new PreparedBatch(this, sql);
    }

    public Call createCall(String sql) {
        return new Call(this, sql);
    }

    public Query createQuery(String sql) {
        return new Query(this, sql);
    }

    public Script createScript(String sql) {
        return new Script(this, sql);
    }

    public Update createUpdate(String sql) {
        return new Update(this, sql);
    }

    public boolean isInTransaction() {
        return this.transactions.isInTransaction(this);
    }

    public Handle begin() {
        this.transactions.begin(this);
        LOG.trace("Handle [{}] begin transaction", (Object)this);
        return this;
    }

    public Handle commit() {
        long start = System.nanoTime();
        this.transactions.commit(this);
        LOG.trace("Handle [{}] commit transaction in {}ms", (Object)this, (Object)Handle.msSince(start));
        return this;
    }

    public Handle rollback() {
        long start = System.nanoTime();
        this.transactions.rollback(this);
        LOG.trace("Handle [{}] rollback transaction in {}ms", (Object)this, (Object)Handle.msSince(start));
        return this;
    }

    public Handle rollbackToSavepoint(String savepointName) {
        long start = System.nanoTime();
        this.transactions.rollbackToSavepoint(this, savepointName);
        LOG.trace("Handle [{}] rollback to savepoint \"{}\" in {}ms", new Object[]{this, savepointName, Handle.msSince(start)});
        return this;
    }

    private static long msSince(long start) {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
    }

    public Handle savepoint(String name) {
        this.transactions.savepoint(this, name);
        LOG.trace("Handle [{}] savepoint \"{}\"", (Object)this, (Object)name);
        return this;
    }

    public Handle release(String savepointName) {
        this.transactions.releaseSavepoint(this, savepointName);
        LOG.trace("Handle [{}] release savepoint \"{}\"", (Object)this, (Object)savepointName);
        return this;
    }

    public boolean isReadOnly() {
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException e) {
            throw new UnableToManipulateTransactionIsolationLevelException("Could not getReadOnly", e);
        }
    }

    public Handle setReadOnly(boolean readOnly) {
        try {
            this.connection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw new UnableToManipulateTransactionIsolationLevelException("Could not setReadOnly", e);
        }
        return this;
    }

    public <R, X extends Exception> R inTransaction(HandleCallback<R, X> callback) throws X {
        return this.isInTransaction() ? callback.withHandle(this) : this.transactions.inTransaction(this, callback);
    }

    public <X extends Exception> void useTransaction(HandleConsumer<X> consumer) throws X {
        this.inTransaction(consumer.asCallback());
    }

    public <R, X extends Exception> R inTransaction(TransactionIsolationLevel level, HandleCallback<R, X> callback) throws X {
        if (this.isInTransaction()) {
            TransactionIsolationLevel currentLevel = this.getTransactionIsolationLevel();
            if (currentLevel != level && level != TransactionIsolationLevel.UNKNOWN) {
                throw new TransactionException("Tried to execute nested transaction with isolation level " + (Object)((Object)level) + ", but already running in a transaction with isolation level " + (Object)((Object)currentLevel) + ".");
            }
            return callback.withHandle(this);
        }
        try (TransactionResetter tr = new TransactionResetter(this.getTransactionIsolationLevel());){
            this.setTransactionIsolation(level);
            R r = this.transactions.inTransaction(this, level, callback);
            return r;
        }
    }

    public <X extends Exception> void useTransaction(TransactionIsolationLevel level, HandleConsumer<X> consumer) throws X {
        this.inTransaction(level, consumer.asCallback());
    }

    public void setTransactionIsolation(TransactionIsolationLevel level) {
        if (level != TransactionIsolationLevel.UNKNOWN) {
            this.setTransactionIsolation(level.intValue());
        }
    }

    public void setTransactionIsolation(int level) {
        try {
            if (this.connection.getTransactionIsolation() != level) {
                this.connection.setTransactionIsolation(level);
            }
        }
        catch (SQLException e) {
            throw new UnableToManipulateTransactionIsolationLevelException(level, e);
        }
    }

    public TransactionIsolationLevel getTransactionIsolationLevel() {
        try {
            return TransactionIsolationLevel.valueOf(this.connection.getTransactionIsolation());
        }
        catch (SQLException e) {
            throw new UnableToManipulateTransactionIsolationLevelException("unable to access current setting", e);
        }
    }

    public <T> T attach(Class<T> extensionType) {
        return this.getConfig(Extensions.class).findFor(extensionType, ConstantHandleSupplier.of(this)).orElseThrow(() -> new NoSuchExtensionException("Extension not found: " + extensionType));
    }

    public ExtensionMethod getExtensionMethod() {
        return this.localExtensionMethod.get();
    }

    void setExtensionMethod(ExtensionMethod extensionMethod) {
        this.localExtensionMethod.set(extensionMethod);
    }

    void setExtensionMethodThreadLocal(ThreadLocal<ExtensionMethod> extensionMethodThreadLocal) {
        this.localExtensionMethod = Objects.requireNonNull(extensionMethodThreadLocal);
    }

    private class TransactionResetter
    implements Closeable {
        private final TransactionIsolationLevel initial;

        TransactionResetter(TransactionIsolationLevel initial) {
            this.initial = initial;
        }

        @Override
        public void close() {
            Handle.this.setTransactionIsolation(this.initial);
        }
    }

    static interface ConnectionCloser {
        public void close(Connection var1) throws SQLException;
    }
}

