/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.statement.Binding;
import org.jdbi.v3.core.statement.ParsedParameters;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;

class ArgumentBinder {
    ArgumentBinder() {
    }

    static void bind(ParsedParameters parameters, Binding binding, PreparedStatement statement, StatementContext context) {
        if (parameters.isPositional()) {
            ArgumentBinder.bindPositional(parameters.getParameterCount(), binding, statement, context);
        } else {
            ArgumentBinder.bindNamed(parameters.getParameterNames(), binding, statement, context);
        }
    }

    private static void bindPositional(int size, Binding binding, PreparedStatement statement, StatementContext context) {
        for (int i = 0; i < size; ++i) {
            try {
                Argument argument = binding.findForPosition(i).orElse(null);
                if (argument == null) continue;
                argument.apply(i + 1, statement, context);
                continue;
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException("Exception while binding positional param at (0 based) position " + i, e, context);
            }
        }
    }

    private static void bindNamed(List<String> parameterNames, Binding binding, PreparedStatement statement, StatementContext context) {
        if (parameterNames.isEmpty() && !binding.isEmpty()) {
            throw new UnableToExecuteStatementException(String.format("Unable to execute. The query doesn't have named parameters, but provided binding '%s'.", binding), context);
        }
        for (int i = 0; i < parameterNames.size(); ++i) {
            String param = parameterNames.get(i);
            try {
                binding.findForName(param, context).orElseThrow(() -> new UnableToExecuteStatementException(String.format("Unable to execute, no named parameter matches '%s'.", param), context)).apply(i + 1, statement, context);
                continue;
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException(String.format("Exception while binding named parameter '%s'", param), e, context);
            }
        }
    }
}

