/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.mapper.EnumMapper;
import org.jdbi.v3.core.mapper.MappingException;
import org.jdbi.v3.core.statement.StatementContext;

public class BuiltInMapperFactory
implements ColumnMapperFactory {
    private static final Map<Class<?>, ColumnMapper<?>> mappers = new HashMap();

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        Class<?> rawType = GenericTypes.getErasedType(type);
        if (rawType.isEnum()) {
            return Optional.of(EnumMapper.byName(rawType.asSubclass(Enum.class)));
        }
        return Optional.ofNullable(mappers.get(rawType));
    }

    private static <T> ColumnMapper<T> primitiveMapper(ColumnGetter<T> getter) {
        return (r, i, ctx) -> getter.get(r, i);
    }

    private static <T> ColumnMapper<T> referenceMapper(ColumnGetter<T> getter) {
        return (r, i, ctx) -> {
            Object value = getter.get(r, i);
            return r.wasNull() ? null : value;
        };
    }

    private static char getChar(ResultSet r, int i) throws SQLException {
        Character character = BuiltInMapperFactory.getCharacter(r, i);
        return character == null ? (char)'\u0000' : character.charValue();
    }

    private static Character getCharacter(ResultSet r, int i) throws SQLException {
        String s = r.getString(i);
        if (s != null && !s.isEmpty()) {
            return Character.valueOf(s.charAt(0));
        }
        return null;
    }

    private static URI getURI(ResultSet r, int i) throws SQLException {
        String s = r.getString(i);
        try {
            return s != null ? new URI(s) : null;
        }
        catch (URISyntaxException e) {
            throw new SQLException("Failed to convert data to URI", e);
        }
    }

    private static UUID getUUID(ResultSet r, int i, StatementContext ctx) throws SQLException {
        String s = r.getString(i);
        if (s == null) {
            return null;
        }
        return UUID.fromString(s);
    }

    private static Instant getInstant(ResultSet r, int i) throws SQLException {
        Timestamp ts = r.getTimestamp(i);
        return ts == null ? null : ts.toInstant();
    }

    private static LocalDate getLocalDate(ResultSet r, int i) throws SQLException {
        Timestamp ts = r.getTimestamp(i);
        return ts == null ? null : ts.toLocalDateTime().toLocalDate();
    }

    private static LocalDateTime getLocalDateTime(ResultSet r, int i) throws SQLException {
        Timestamp ts = r.getTimestamp(i);
        return ts == null ? null : ts.toLocalDateTime();
    }

    private static OffsetDateTime getOffsetDateTime(ResultSet r, int i) throws SQLException {
        Timestamp ts = r.getTimestamp(i);
        return ts == null ? null : OffsetDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault());
    }

    private static ZonedDateTime getZonedDateTime(ResultSet r, int i) throws SQLException {
        Timestamp ts = r.getTimestamp(i);
        return ts == null ? null : ZonedDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault());
    }

    private static LocalTime getLocalTime(ResultSet r, int i) throws SQLException {
        Time time = r.getTime(i);
        return time == null ? null : time.toLocalTime();
    }

    private static ZoneId getZoneId(ResultSet r, int i) throws SQLException {
        String id = r.getString(i);
        return id == null ? null : ZoneId.of(id);
    }

    private static InetAddress getInetAddress(ResultSet r, int i, StatementContext ctx) throws SQLException {
        String hostname = r.getString(i);
        try {
            return hostname == null ? null : InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            throw new MappingException("Could not map InetAddress", e);
        }
    }

    static {
        mappers.put(Boolean.TYPE, BuiltInMapperFactory.primitiveMapper(ResultSet::getBoolean));
        mappers.put(Byte.TYPE, BuiltInMapperFactory.primitiveMapper(ResultSet::getByte));
        mappers.put(Character.TYPE, BuiltInMapperFactory.primitiveMapper(BuiltInMapperFactory::getChar));
        mappers.put(Short.TYPE, BuiltInMapperFactory.primitiveMapper(ResultSet::getShort));
        mappers.put(Integer.TYPE, BuiltInMapperFactory.primitiveMapper(ResultSet::getInt));
        mappers.put(Long.TYPE, BuiltInMapperFactory.primitiveMapper(ResultSet::getLong));
        mappers.put(Float.TYPE, BuiltInMapperFactory.primitiveMapper(ResultSet::getFloat));
        mappers.put(Double.TYPE, BuiltInMapperFactory.primitiveMapper(ResultSet::getDouble));
        mappers.put(Boolean.class, BuiltInMapperFactory.referenceMapper(ResultSet::getBoolean));
        mappers.put(Byte.class, BuiltInMapperFactory.referenceMapper(ResultSet::getByte));
        mappers.put(Character.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getCharacter));
        mappers.put(Short.class, BuiltInMapperFactory.referenceMapper(ResultSet::getShort));
        mappers.put(Integer.class, BuiltInMapperFactory.referenceMapper(ResultSet::getInt));
        mappers.put(Long.class, BuiltInMapperFactory.referenceMapper(ResultSet::getLong));
        mappers.put(Float.class, BuiltInMapperFactory.referenceMapper(ResultSet::getFloat));
        mappers.put(Double.class, BuiltInMapperFactory.referenceMapper(ResultSet::getDouble));
        mappers.put(BigDecimal.class, BuiltInMapperFactory.referenceMapper(ResultSet::getBigDecimal));
        mappers.put(String.class, BuiltInMapperFactory.referenceMapper(ResultSet::getString));
        mappers.put(byte[].class, BuiltInMapperFactory.referenceMapper(ResultSet::getBytes));
        mappers.put(Timestamp.class, BuiltInMapperFactory.referenceMapper(ResultSet::getTimestamp));
        mappers.put(InetAddress.class, BuiltInMapperFactory::getInetAddress);
        mappers.put(URL.class, BuiltInMapperFactory.referenceMapper(ResultSet::getURL));
        mappers.put(URI.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getURI));
        mappers.put(UUID.class, BuiltInMapperFactory::getUUID);
        mappers.put(Instant.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getInstant));
        mappers.put(LocalDate.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getLocalDate));
        mappers.put(LocalDateTime.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getLocalDateTime));
        mappers.put(OffsetDateTime.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getOffsetDateTime));
        mappers.put(ZonedDateTime.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getZonedDateTime));
        mappers.put(LocalTime.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getLocalTime));
        mappers.put(ZoneId.class, BuiltInMapperFactory.referenceMapper(BuiltInMapperFactory::getZoneId));
    }

    @FunctionalInterface
    static interface ColumnGetter<T> {
        public T get(ResultSet var1, int var2) throws SQLException;
    }
}

