/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Optional;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ObjectPropertyNamedArgumentFinder;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;

public class ObjectFieldArguments
extends ObjectPropertyNamedArgumentFinder {
    public ObjectFieldArguments(String prefix, Object bean) {
        super(prefix, bean);
    }

    @Override
    Optional<Argument> find0(String name, StatementContext ctx) {
        try {
            for (Field field : this.object.getClass().getFields()) {
                if (!field.getName().equals(name)) continue;
                Object fieldValue = field.get(this.object);
                Type fieldType = field.getGenericType();
                Optional<Argument> argument = ctx.findArgumentFor(fieldType, fieldValue);
                if (!argument.isPresent()) {
                    throw new UnableToCreateStatementException(String.format("No argument factory registered for type [%s] for field [%s] on [%s]", fieldType, name, this.object), ctx);
                }
                return argument;
            }
        }
        catch (IllegalAccessException e) {
            throw new UnableToCreateStatementException(String.format("Access exception getting field for bean property [%s] on [%s]", name, this.object), e, ctx);
        }
        return Optional.empty();
    }

    public String toString() {
        return "{lazy bean field arguments \"" + this.object + "\"";
    }
}

