/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Optional;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.MethodReturnValueNamedArgumentFinder;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;

public class BeanPropertyArguments
extends MethodReturnValueNamedArgumentFinder {
    private BeanInfo info;

    public BeanPropertyArguments(String prefix, Object bean) {
        super(prefix, bean);
        try {
            this.info = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException e) {
            throw new UnableToCreateStatementException("Failed to introspect object which is supposed to be used to set named args for a statement via JavaBean properties", e);
        }
    }

    @Override
    public Optional<Argument> find0(String name, StatementContext ctx) {
        for (PropertyDescriptor descriptor : this.info.getPropertyDescriptors()) {
            if (!name.equals(descriptor.getName())) continue;
            Method getter = descriptor.getReadMethod();
            if (getter == null) {
                throw new UnableToCreateStatementException(String.format("No getter method found for bean property [%s] on [%s]", name, this.object), ctx);
            }
            return this.getArgumentForMethod(getter, ctx);
        }
        return Optional.empty();
    }

    public String toString() {
        return "{lazy bean property arguments \"" + this.object + "\"";
    }
}

