/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.commonstext;

import java.util.function.Consumer;
import org.apache.commons.text.StringSubstitutor;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.TemplateEngine;

public class StringSubstitutorTemplateEngine
implements TemplateEngine {
    static final String DEFAULT_PREFIX = "${";
    static final String DEFAULT_SUFFIX = "}";
    static final char DEFAULT_ESCAPE = '\\';
    private final Consumer<StringSubstitutor> customizer;

    public StringSubstitutorTemplateEngine() {
        this(substitutor -> {
            substitutor.setVariablePrefix(DEFAULT_PREFIX);
            substitutor.setVariableSuffix(DEFAULT_SUFFIX);
            substitutor.setEscapeChar('\\');
        });
    }

    public StringSubstitutorTemplateEngine(Consumer<StringSubstitutor> customizer) {
        this.customizer = customizer;
    }

    public String render(String template, StatementContext ctx) {
        StringSubstitutor substitutor = new StringSubstitutor(ctx.getAttributes());
        this.customizer.accept(substitutor);
        return substitutor.replace(template);
    }

    public static StringSubstitutorTemplateEngine between(char prefix, char suffix) {
        return new StringSubstitutorTemplateEngine(substitutor -> {
            substitutor.setVariablePrefix(prefix);
            substitutor.setVariableSuffix(suffix);
        });
    }

    public static StringSubstitutorTemplateEngine between(String prefix, String suffix) {
        return new StringSubstitutorTemplateEngine(substitutor -> {
            substitutor.setVariablePrefix(prefix);
            substitutor.setVariableSuffix(suffix);
        });
    }

    public static StringSubstitutorTemplateEngine between(char prefix, char suffix, char escape) {
        return new StringSubstitutorTemplateEngine(substitutor -> {
            substitutor.setVariablePrefix(prefix);
            substitutor.setVariableSuffix(suffix);
            substitutor.setEscapeChar(escape);
        });
    }

    public static StringSubstitutorTemplateEngine between(String prefix, String suffix, char escape) {
        return new StringSubstitutorTemplateEngine(substitutor -> {
            substitutor.setVariablePrefix(prefix);
            substitutor.setVariableSuffix(suffix);
            substitutor.setEscapeChar(escape);
        });
    }
}

