/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.cache.caffeine;

import com.github.benmanes.caffeine.cache.Caffeine;
import org.jdbi.v3.cache.caffeine.CaffeineCache;
import org.jdbi.v3.cache.caffeine.CaffeineLoadingCache;
import org.jdbi.v3.core.cache.JdbiCache;
import org.jdbi.v3.core.cache.JdbiCacheBuilder;
import org.jdbi.v3.core.cache.JdbiCacheLoader;

public final class CaffeineCacheBuilder
implements JdbiCacheBuilder {
    private final Caffeine<Object, Object> caffeine;

    public static JdbiCacheBuilder instance() {
        return new CaffeineCacheBuilder();
    }

    public CaffeineCacheBuilder(Caffeine<Object, Object> caffeine) {
        this.caffeine = caffeine;
    }

    CaffeineCacheBuilder() {
        this.caffeine = Caffeine.newBuilder().recordStats();
    }

    public <K, V> JdbiCache<K, V> build() {
        return new CaffeineCache(this.caffeine);
    }

    public <K, V> JdbiCache<K, V> buildWithLoader(JdbiCacheLoader<K, V> cacheLoader) {
        return new CaffeineLoadingCache<K, V>(this.caffeine, cacheLoader);
    }

    public JdbiCacheBuilder maxSize(int maxSize) {
        this.caffeine.maximumSize((long)maxSize);
        return this;
    }
}

