/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.jdbcdslog.JdbcDsLogRuntimeException;
import org.jdbcdslog.Loggers;
import org.jdbcdslog.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceProxyBase
implements Serializable {
    private static final long serialVersionUID = -1209576641924549514L;
    protected static Logger logger = LoggerFactory.getLogger(DataSourceProxyBase.class);
    protected static final String TARGET_DS_PARAMETER = "targetDS";
    protected Object targetDs = null;
    protected Map<String, Object> props = new HashMap<String, Object>();
    protected Map<String, Class<?>> propClasses = new HashMap();

    public Connection getConnection() throws SQLException {
        if (this.targetDs == null) {
            throw new SQLException("targetDS parameter has not been passed to Database or URL property.");
        }
        if (this.targetDs instanceof DataSource) {
            Connection con = ((DataSource)this.targetDs).getConnection();
            return ProxyUtils.wrapByConnectionProxy(con);
        }
        throw new SQLException("targetDS doesn't implement DataSource interface.");
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (this.targetDs == null) {
            throw new SQLException("targetDS parameter has not been passed to Database or URL property.");
        }
        if (this.targetDs instanceof DataSource) {
            Connection con = ((DataSource)this.targetDs).getConnection(username, password);
            return ProxyUtils.wrapByConnectionProxy(con);
        }
        throw new SQLException("targetDS doesn't implement DataSource interface.");
    }

    public PrintWriter getLogWriter() throws SQLException {
        if (this.targetDs instanceof DataSource) {
            return ((DataSource)this.targetDs).getLogWriter();
        }
        if (this.targetDs instanceof XADataSource) {
            return ((XADataSource)this.targetDs).getLogWriter();
        }
        if (this.targetDs instanceof ConnectionPoolDataSource) {
            return ((ConnectionPoolDataSource)this.targetDs).getLogWriter();
        }
        throw new SQLException("targetDS doesn't have getLogWriter() method");
    }

    public int getLoginTimeout() throws SQLException {
        if (this.targetDs instanceof DataSource) {
            return ((DataSource)this.targetDs).getLoginTimeout();
        }
        if (this.targetDs instanceof XADataSource) {
            return ((XADataSource)this.targetDs).getLoginTimeout();
        }
        if (this.targetDs instanceof ConnectionPoolDataSource) {
            return ((ConnectionPoolDataSource)this.targetDs).getLoginTimeout();
        }
        throw new SQLException("targetDS doesn't have getLogTimeout() method");
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        if (this.targetDs instanceof DataSource) {
            ((DataSource)this.targetDs).setLogWriter(out);
        }
        if (this.targetDs instanceof XADataSource) {
            ((XADataSource)this.targetDs).setLogWriter(out);
        }
        if (this.targetDs instanceof ConnectionPoolDataSource) {
            ((ConnectionPoolDataSource)this.targetDs).setLogWriter(out);
        }
        throw new SQLException("targetDS doesn't have setLogWriter() method");
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        if (this.targetDs instanceof DataSource) {
            ((DataSource)this.targetDs).setLoginTimeout(seconds);
        }
        if (this.targetDs instanceof XADataSource) {
            ((XADataSource)this.targetDs).setLoginTimeout(seconds);
        }
        if (this.targetDs instanceof ConnectionPoolDataSource) {
            ((ConnectionPoolDataSource)this.targetDs).setLoginTimeout(seconds);
        }
        throw new SQLException("targetDS doesn't have setLogWriter() method");
    }

    public XAConnection getXAConnection() throws SQLException {
        if (this.targetDs == null) {
            throw new SQLException("targetDS parameter has not been passed to Database or URL property.");
        }
        if (this.targetDs instanceof XADataSource) {
            XAConnection con = ((XADataSource)this.targetDs).getXAConnection();
            return ProxyUtils.wrapByXaConnection(con);
        }
        throw new SQLException("targetDS doesn't implement XADataSource interface.");
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        if (this.targetDs == null) {
            throw new SQLException("targetDS parameter has not been passed to Database or URL property.");
        }
        if (this.targetDs instanceof XADataSource) {
            return ProxyUtils.wrapByXaConnection(((XADataSource)this.targetDs).getXAConnection(user, password));
        }
        throw new SQLException("targetDS doesn't implement XADataSource interface.");
    }

    public PooledConnection getPooledConnection() throws SQLException {
        if (this.targetDs == null) {
            throw new SQLException("targetDS parameter has not been passed to Database or URL property.");
        }
        if (this.targetDs instanceof ConnectionPoolDataSource) {
            return ProxyUtils.wrapByPooledConnection(((ConnectionPoolDataSource)this.targetDs).getPooledConnection());
        }
        throw new SQLException("targetDS doesn't implement ConnectionPoolDataSource interface.");
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        if (this.targetDs == null) {
            throw new SQLException("targetDS parameter has not been passed to Database or URL property.");
        }
        if (this.targetDs instanceof ConnectionPoolDataSource) {
            return ProxyUtils.wrapByPooledConnection(((ConnectionPoolDataSource)this.targetDs).getPooledConnection(user, password));
        }
        throw new SQLException("targetDS doesn't implement ConnectionPoolDataSource interface.");
    }

    protected void invokeTargetSetMethod(String methodName, Object param, Class<?> paramClass) {
        if (this.targetDs == null) {
            this.props.put(methodName, param);
            this.propClasses.put(methodName, paramClass);
            return;
        }
        logger.debug("invokeTargetSetMethod: {} ({})", (Object)methodName, param);
        try {
            Method me = this.targetDs.getClass().getMethod(methodName, paramClass);
            if (me != null) {
                me.invoke(this.targetDs, param);
            }
        }
        catch (Exception e) {
            Loggers.connectionLogger.error("Error in invoking setter method {}({})", new Object[]{methodName, param, e});
        }
    }

    public void setURL(String url) throws JdbcDsLogRuntimeException {
        url = this.initTargetDS(url);
        this.invokeTargetSetMethod("setURL", url, String.class);
    }

    private String initTargetDS(String url) throws JdbcDsLogRuntimeException {
        logger.debug("initTargetDS: url={}, targetDs={}", (Object)url, this.targetDs);
        try {
            if (url == null || this.targetDs != null) {
                return url;
            }
            logger.debug("Parse url. {}", (Object)url);
            StringTokenizer ts = new StringTokenizer(url, ":/;=&?", false);
            String targetDSName = null;
            while (ts.hasMoreTokens()) {
                String s = ts.nextToken();
                logger.debug("s = {}", (Object)s);
                if (!TARGET_DS_PARAMETER.equals(s) || !ts.hasMoreTokens()) continue;
                targetDSName = ts.nextToken();
                break;
            }
            if (targetDSName == null) {
                return url;
            }
            url = url.substring(0, url.length() - targetDSName.length() - TARGET_DS_PARAMETER.length() - 2);
            this.setTargetDS(targetDSName);
            return url;
        }
        catch (Throwable t) {
            Loggers.connectionLogger.error("Error in initTargetDS() url={}", (Object)url, (Object)t);
            throw new JdbcDsLogRuntimeException(t);
        }
    }

    public void setTargetDSDirect(Object dataSource) {
        this.targetDs = dataSource;
        logger.debug("setTargetDSDirect(): targetDS initialized.");
    }

    public void setTargetDS(String targetDSName) throws JdbcDsLogRuntimeException, InstantiationException, IllegalAccessException {
        try {
            Class<?> cl = Class.forName(targetDSName);
            if (cl == null) {
                throw new JdbcDsLogRuntimeException("Can't load class of targetDS.");
            }
            Object targetObj = cl.newInstance();
            this.targetDs = targetObj;
            logger.debug("setTargetDS(): targetDS initialized.");
            this.setPropertiesForTargetDS();
        }
        catch (Throwable t) {
            Loggers.connectionLogger.error("Error in setTargetDS(): targetDSName={}", (Object)targetDSName, (Object)t);
            throw new JdbcDsLogRuntimeException(t);
        }
    }

    private void setPropertiesForTargetDS() {
        for (String m : this.props.keySet()) {
            this.invokeTargetSetMethod(m, this.props.get(m), this.propClasses.get(m));
        }
    }

    public void setDatabaseName(String p) {
        this.invokeTargetSetMethod("setDatabaseName", p, String.class);
    }

    public void setDescription(String p) {
        this.invokeTargetSetMethod("setDescription", p, String.class);
    }

    public void setDataSourceName(String p) {
        this.invokeTargetSetMethod("setDataSourceName", p, String.class);
    }

    public void setDriverType(String p) {
        this.invokeTargetSetMethod("setDriverType", p, String.class);
    }

    public void setNetworkProtocol(String p) {
        this.invokeTargetSetMethod("setNetworkProtocol", p, String.class);
    }

    public void setPassword(String p) {
        this.invokeTargetSetMethod("setPassword", p, String.class);
    }

    public void setPortNumber(int p) {
        this.invokeTargetSetMethod("setPortNumber", new Integer(p), Integer.TYPE);
    }

    public void setServerName(String p) {
        this.invokeTargetSetMethod("setServerName", p, String.class);
    }

    public void setServiceName(String p) {
        this.invokeTargetSetMethod("setServiceName", p, String.class);
    }

    public void setTNSEntryName(String p) {
        this.invokeTargetSetMethod("setTNSEntryName", p, String.class);
    }

    public void setUser(String p) {
        this.invokeTargetSetMethod("setUser", p, String.class);
    }

    public void setDatabase(String p) throws JdbcDsLogRuntimeException {
        p = this.initTargetDS(p);
        this.invokeTargetSetMethod("setDatabase", p, String.class);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

