/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import org.jdbcdslog.CallableStatementLoggingHandler;
import org.jdbcdslog.ConnectionLoggingHandler;
import org.jdbcdslog.ConnectionSourceLoggingHandler;
import org.jdbcdslog.LogMetaData;
import org.jdbcdslog.PreparedStatementLoggingHandler;
import org.jdbcdslog.ResultSetLoggingHandler;
import org.jdbcdslog.StatementLoggingHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyUtils {
    private static Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    public static <T> T proxyForCompatibleInterfaces(Class<?> clazz, Class<T> requiredInterface, InvocationHandler invocationHandler) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), ProxyUtils.findCompatibleInterfaces(clazz, requiredInterface), invocationHandler);
    }

    public static Class<?>[] findCompatibleInterfaces(Class<?> clazz, Class<?> requiredInterface) {
        ArrayList interfaces = new ArrayList();
        while (!clazz.equals(Object.class)) {
            for (Class<?> iface : clazz.getInterfaces()) {
                if (!requiredInterface.isAssignableFrom(iface)) continue;
                interfaces.add(iface);
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces.toArray(EMPTY_CLASS_ARRAY);
    }

    public static Statement wrapByStatementProxy(LogMetaData logMetaData, Object r) {
        return ProxyUtils.proxyForCompatibleInterfaces(r.getClass(), Statement.class, new StatementLoggingHandler(logMetaData, (Statement)r));
    }

    public static PreparedStatement wrapByPreparedStatementProxy(LogMetaData logMetaData, Object r, String sql) {
        return ProxyUtils.proxyForCompatibleInterfaces(r.getClass(), PreparedStatement.class, new PreparedStatementLoggingHandler(logMetaData, (PreparedStatement)r, sql));
    }

    public static CallableStatement wrapByCallableStatementProxy(LogMetaData logMetaData, Object r, String sql) {
        return ProxyUtils.proxyForCompatibleInterfaces(r.getClass(), CallableStatement.class, new CallableStatementLoggingHandler(logMetaData, (CallableStatement)r, sql));
    }

    public static Connection wrapByConnectionProxy(Object r) {
        return ProxyUtils.proxyForCompatibleInterfaces(r.getClass(), Connection.class, new ConnectionLoggingHandler(r));
    }

    public static Connection wrapByConnectionProxy(LogMetaData logMetaData, Object r) {
        return ProxyUtils.proxyForCompatibleInterfaces(r.getClass(), Connection.class, new ConnectionLoggingHandler(logMetaData, r));
    }

    public static ResultSet wrapByResultSetProxy(LogMetaData logMetaData, ResultSet r) {
        return ProxyUtils.proxyForCompatibleInterfaces(r.getClass(), ResultSet.class, new ResultSetLoggingHandler(logMetaData, r));
    }

    public static XAConnection wrapByXaConnection(XAConnection con) {
        return ProxyUtils.proxyForCompatibleInterfaces(con.getClass(), XAConnection.class, new ConnectionSourceLoggingHandler(con));
    }

    public static PooledConnection wrapByPooledConnection(PooledConnection con) {
        return ProxyUtils.proxyForCompatibleInterfaces(con.getClass(), PooledConnection.class, new ConnectionSourceLoggingHandler(con));
    }

    public static Object wrapByConnectionSourceProxy(Object r, Class<?> interf) {
        return ProxyUtils.proxyForCompatibleInterfaces(r.getClass(), interf, new ConnectionSourceLoggingHandler(r));
    }

    public static Object wrap(LogMetaData logMetaData, Object r, Object ... args) {
        if (r instanceof Connection) {
            return ProxyUtils.wrapByConnectionProxy(logMetaData, r);
        }
        if (r instanceof CallableStatement) {
            return ProxyUtils.wrapByCallableStatementProxy(logMetaData, r, (String)args[0]);
        }
        if (r instanceof PreparedStatement) {
            return ProxyUtils.wrapByPreparedStatementProxy(logMetaData, r, (String)args[0]);
        }
        if (r instanceof Statement) {
            return ProxyUtils.wrapByStatementProxy(logMetaData, r);
        }
        if (r instanceof ResultSet) {
            return ProxyUtils.wrapByResultSetProxy(logMetaData, (ResultSet)r);
        }
        return r;
    }
}

