/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdbcdslog.LogMetaData;
import org.jdbcdslog.LogUtils;
import org.jdbcdslog.Loggers;
import org.jdbcdslog.ProxyUtils;
import org.jdbcdslog.StatementLoggingHandlerTemplate;

public class PreparedStatementLoggingHandler
extends StatementLoggingHandlerTemplate {
    protected Map<Integer, Object> parameters = new TreeMap<Integer, Object>();
    protected String sql = null;
    protected List<Map<Integer, Object>> batchParameters;
    protected static final Set<String> SET_METHODS = new HashSet<String>(Arrays.asList("setAsciiStream", "setBigDecimal", "setBinaryStream", "setBoolean", "setByte", "setBytes", "setCharacterStream", "setDate", "setDouble", "setFloat", "setInt", "setLong", "setObject", "setShort", "setString", "setTime", "setTimestamp", "setURL"));
    protected static final Set<String> EXECUTE_METHODS = new HashSet<String>(Arrays.asList("addBatch", "execute", "executeQuery", "executeUpdate", "executeBatch"));

    public PreparedStatementLoggingHandler(LogMetaData logMetaData, PreparedStatement ps, String sql) {
        super(logMetaData, ps);
        this.sql = sql;
    }

    protected boolean needsLogging(Object proxy, Method method, Object[] args) {
        return (Loggers.statementLogger.isInfoEnabled() || Loggers.slowQueryLogger.isInfoEnabled()) && EXECUTE_METHODS.contains(method.getName());
    }

    protected void appendStatement(StringBuilder sb, Object proxy, Method method, Object[] args) {
        LogUtils.appendSql(sb, this.sql, this.parameters, null);
    }

    protected void doAddBatch(Object proxy, Method method, Object[] args) {
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList<Map<Integer, Object>>();
        }
        this.batchParameters.add(new TreeMap<Integer, Object>(this.parameters));
    }

    protected void appendBatchStatements(StringBuilder sb) {
        LogUtils.appendBatchSqls(sb, this.sql, this.batchParameters, null);
    }

    protected Object doAfterInvoke(Object proxy, Method method, Object[] args, Object result) {
        Object r = result;
        if ("unwrap".equals(method.getName())) {
            Class unwrapClass = (Class)args[0];
            if (r == this.target && unwrapClass.isInstance(proxy)) {
                r = proxy;
            } else if (unwrapClass.isInterface() && PreparedStatement.class.isAssignableFrom(unwrapClass)) {
                r = ProxyUtils.wrapByPreparedStatementProxy(this.logMetaData, r, this.sql);
            }
        }
        if (r instanceof ResultSet) {
            r = ProxyUtils.wrapByResultSetProxy(this.logMetaData, (ResultSet)r);
        }
        if (SET_METHODS.contains(method.getName()) && args[0] instanceof Integer) {
            this.parameters.put((Integer)args[0], args[1]);
        }
        if ("clearParameters".equals(method.getName())) {
            this.parameters.clear();
        }
        if (this.batchParameters != null && "executeBatch".equals(method.getName())) {
            this.batchParameters.clear();
        }
        return r;
    }

    protected void handleException(Throwable t, Object proxy, Method method, Object[] args) throws Throwable {
        LogUtils.handleException(t, Loggers.statementLogger, LogUtils.createLogEntry(method, this.sql, this.parameters, null));
    }
}

