/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.jdbcdslog.LogMetaData;
import org.jdbcdslog.LogUtils;
import org.jdbcdslog.Loggers;
import org.jdbcdslog.LoggingHandlerSupport;
import org.jdbcdslog.ProxyUtils;

public class ConnectionLoggingHandler
extends LoggingHandlerSupport {
    protected LogMetaData logMetaData = null;

    public ConnectionLoggingHandler(Object target) {
        this(null, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionLoggingHandler(LogMetaData logMetaData, Object target) {
        super(target);
        this.logMetaData = logMetaData == null ? LogMetaData.create() : logMetaData;
        Map<String, String> oldMdc = LogUtils.setMdc(this.logMetaData);
        if (Loggers.connectionLogger.isInfoEnabled()) {
            try {
                DatabaseMetaData md = ((Connection)target).getMetaData();
                Loggers.connectionLogger.info("Connected to URL {} for user {}", (Object)md.getURL(), (Object)md.getUserName());
            }
            catch (SQLException ex) {
                Loggers.connectionLogger.error("Problem reading connection metadata", (Throwable)ex);
            }
            finally {
                LogUtils.resetMdc(oldMdc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Map<String, String> oldMdc = LogUtils.setMdc(this.logMetaData);
        try {
            Object r = method.invoke(this.target, args);
            if ("unwrap".equals(method.getName())) {
                Class unwrapClass = (Class)args[0];
                if (r == this.target && unwrapClass.isInstance(proxy)) {
                    r = proxy;
                } else if (unwrapClass.isInterface() && Connection.class.isAssignableFrom(unwrapClass)) {
                    r = ProxyUtils.wrapByConnectionProxy(this.logMetaData, r);
                }
            } else {
                r = method.getName().equals("createStatement") ? ProxyUtils.wrapByStatementProxy(this.logMetaData, r) : (method.getName().equals("prepareCall") ? ProxyUtils.wrapByCallableStatementProxy(this.logMetaData, r, (String)args[0]) : (method.getName().equals("prepareStatement") ? ProxyUtils.wrapByPreparedStatementProxy(this.logMetaData, r, (String)args[0]) : ProxyUtils.wrap(this.logMetaData, r, new Object[0])));
            }
            Object object = r;
            return object;
        }
        catch (Throwable t) {
            LogUtils.handleException(t, Loggers.connectionLogger, LogUtils.createLogEntry(method, null, null, null));
        }
        finally {
            LogUtils.resetMdc(oldMdc);
        }
        return null;
    }
}

