/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import java.util.Iterator;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscArrayQueue;
import org.jctools.queues.MpscCompoundQueueConsumerQueueIndex;
import org.jctools.util.PortableJvmInfo;

public class MpscCompoundQueue<E>
extends MpscCompoundQueueConsumerQueueIndex<E> {
    long p01;
    long p02;
    long p03;
    long p04;
    long p05;
    long p06;
    long p07;
    long p10;
    long p11;
    long p12;
    long p13;
    long p14;
    long p15;
    long p16;
    long p17;

    public MpscCompoundQueue(int capacity) {
        this(capacity, PortableJvmInfo.CPUs);
    }

    public MpscCompoundQueue(int capacity, int queueParallelism) {
        super(capacity, queueParallelism);
    }

    @Override
    public boolean offer(E e) {
        int status;
        if (null == e) {
            throw new NullPointerException();
        }
        int start = (int)(Thread.currentThread().getId() & (long)this.parallelQueuesMask);
        if (this.queues[start].offer(e)) {
            return true;
        }
        do {
            status = 0;
            for (int i = start; i < start + this.parallelQueues; ++i) {
                int s = this.queues[i & this.parallelQueuesMask].failFastOffer(e);
                if (s == 0) {
                    return true;
                }
                status += s;
            }
        } while (status != this.parallelQueues);
        return false;
    }

    @Override
    public E poll() {
        int qIndex;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        for (qIndex = this.consumerQueueIndex & this.parallelQueuesMask; qIndex < limit && (e = (E)this.queues[qIndex & this.parallelQueuesMask].poll()) == null; ++qIndex) {
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public E peek() {
        int qIndex;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        for (qIndex = this.consumerQueueIndex & this.parallelQueuesMask; qIndex < limit && (e = (E)this.queues[qIndex & this.parallelQueuesMask].peek()) == null; ++qIndex) {
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public int size() {
        int size = 0;
        for (MpscArrayQueue lane : this.queues) {
            size += lane.size();
        }
        return size;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean relaxedOffer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        int parallelQueuesMask = this.parallelQueuesMask;
        int start = (int)(Thread.currentThread().getId() & (long)parallelQueuesMask);
        MpscArrayQueue[] queues = this.queues;
        int status = 0;
        status = queues[start].failFastOffer(e);
        if (status == 0) {
            return true;
        }
        while (true) {
            int parallelQueues = this.parallelQueues;
            for (int i = start + 1; i < start + parallelQueues; ++i) {
                int s = queues[i & parallelQueuesMask].failFastOffer(e);
                if (s == 0) {
                    return true;
                }
                status += s;
            }
            if (status == parallelQueues) {
                return false;
            }
            status = 0;
        }
    }

    @Override
    public E relaxedPoll() {
        int qIndex;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        for (qIndex = this.consumerQueueIndex & this.parallelQueuesMask; qIndex < limit && (e = (E)this.queues[qIndex & this.parallelQueuesMask].relaxedPoll()) == null; ++qIndex) {
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public E relaxedPeek() {
        int qIndex;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        for (qIndex = this.consumerQueueIndex & this.parallelQueuesMask; qIndex < limit && (e = (E)this.queues[qIndex & this.parallelQueuesMask].relaxedPeek()) == null; ++qIndex) {
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public int capacity() {
        return this.queues.length * this.queues[0].capacity();
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        int limit = this.capacity();
        return this.drain(c, limit);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        for (int i = 0; i < limit; ++i) {
            E e = this.relaxedPoll();
            if (e == null) {
                return i;
            }
            c.accept(e);
        }
        return limit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        int idleCounter = 0;
        while (exit.keepRunning()) {
            E e = this.relaxedPoll();
            if (e == null) {
                idleCounter = wait.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
            c.accept(e);
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        int idleCounter = 0;
        while (exit.keepRunning()) {
            E e = s.get();
            while (!this.relaxedOffer(e)) {
                idleCounter = wait.idle(idleCounter);
            }
            idleCounter = 0;
        }
    }
}

