/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues.atomic;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jctools.queues.atomic.BaseSpscLinkedAtomicArrayQueue;
import org.jctools.util.Pow2;

public class SpscUnboundedAtomicArrayQueue<E>
extends BaseSpscLinkedAtomicArrayQueue<E> {
    public SpscUnboundedAtomicArrayQueue(int chunkSize) {
        AtomicReferenceArray buffer;
        int chunkCapacity = Math.max(Pow2.roundToPowerOfTwo(chunkSize), 16);
        long mask = chunkCapacity - 1;
        this.producerBuffer = buffer = SpscUnboundedAtomicArrayQueue.allocate(chunkCapacity + 1);
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerBufferLimit = mask - 1L;
        this.soProducerIndex(0L);
    }

    @Override
    protected boolean offerColdPath(AtomicReferenceArray<E> buffer, long mask, E e, long pIndex, int offset) {
        long lookAheadStep = (mask + 1L) / 4L;
        long pBufferLimit = pIndex + lookAheadStep;
        if (null == this.lvElement(buffer, SpscUnboundedAtomicArrayQueue.calcElementOffset(pBufferLimit, mask))) {
            this.producerBufferLimit = pBufferLimit - 1L;
            this.writeToQueue(buffer, e, pIndex, offset);
        } else if (null == this.lvElement(buffer, SpscUnboundedAtomicArrayQueue.calcElementOffset(pIndex + 1L, mask))) {
            this.writeToQueue(buffer, e, pIndex, offset);
        } else {
            AtomicReferenceArray newBuffer;
            this.producerBuffer = newBuffer = SpscUnboundedAtomicArrayQueue.allocate((int)(mask + 2L));
            this.producerBufferLimit = pIndex + mask - 1L;
            this.linkOldToNew(pIndex, buffer, offset, newBuffer, offset, e);
        }
        return true;
    }
}

