/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues.atomic;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jctools.queues.IndexedQueueSizeUtil;
import org.jctools.queues.QueueProgressIndicators;
import org.jctools.queues.atomic.BaseSpscLinkedAtomicArrayQueueProducerColdFields;

abstract class BaseSpscLinkedAtomicArrayQueue<E>
extends BaseSpscLinkedAtomicArrayQueueProducerColdFields<E>
implements QueueProgressIndicators,
IndexedQueueSizeUtil.IndexedQueue {
    protected static final Object JUMP = new Object();

    BaseSpscLinkedAtomicArrayQueue() {
    }

    protected final void soProducerIndex(long v) {
        P_INDEX_UPDATER.lazySet(this, v);
    }

    protected final void soConsumerIndex(long v) {
        C_INDEX_UPDATER.lazySet(this, v);
    }

    @Override
    public final long lvProducerIndex() {
        return this.producerIndex;
    }

    @Override
    public final long lvConsumerIndex() {
        return this.consumerIndex;
    }

    protected static <E> AtomicReferenceArray<E> allocate(int capacity) {
        return new AtomicReferenceArray(capacity);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    protected final void soNext(AtomicReferenceArray<E> curr, AtomicReferenceArray<E> next) {
        this.soElement(curr, this.nextArrayOffset(curr), next);
    }

    private void soElement(AtomicReferenceArray curr, int i, Object e) {
        curr.lazySet(i, e);
    }

    protected final AtomicReferenceArray<E> lvNextArrayAndUnlink(AtomicReferenceArray curr) {
        int nextArrayOffset = this.nextArrayOffset(curr);
        AtomicReferenceArray nextBuffer = (AtomicReferenceArray)curr.get(nextArrayOffset);
        this.soElement(curr, nextArrayOffset, null);
        return nextBuffer;
    }

    private int nextArrayOffset(AtomicReferenceArray<E> curr) {
        return curr.length() - 1;
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        AtomicReferenceArray buffer = this.producerBuffer;
        long index = this.producerIndex;
        long mask = this.producerMask;
        int offset = BaseSpscLinkedAtomicArrayQueue.calcElementOffset(index, mask);
        if (index < this.producerBufferLimit) {
            this.writeToQueue(buffer, e, index, offset);
            return true;
        }
        return this.offerColdPath(buffer, mask, e, index, offset);
    }

    protected abstract boolean offerColdPath(AtomicReferenceArray<E> var1, long var2, E var4, long var5, int var7);

    protected final void linkOldToNew(long currIndex, AtomicReferenceArray<E> oldBuffer, int offset, AtomicReferenceArray<E> newBuffer, int offsetInNew, E e) {
        this.soElement(newBuffer, offsetInNew, e);
        this.soNext(oldBuffer, newBuffer);
        this.soElement(oldBuffer, offset, JUMP);
        this.soProducerIndex(currIndex + 1L);
    }

    protected final void writeToQueue(AtomicReferenceArray<E> buffer, E e, long index, int offset) {
        this.soElement(buffer, offset, e);
        this.soProducerIndex(index + 1L);
    }

    @Override
    public E poll() {
        boolean isNextBuffer;
        AtomicReferenceArray buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        int offset = BaseSpscLinkedAtomicArrayQueue.calcElementOffset(index, mask);
        E e = this.lvElement(buffer, offset);
        boolean bl = isNextBuffer = e == JUMP;
        if (null != e && !isNextBuffer) {
            this.soConsumerIndex(index + 1L);
            this.soElement(buffer, offset, null);
            return e;
        }
        if (isNextBuffer) {
            return this.newBufferPoll(buffer, index);
        }
        return null;
    }

    protected E lvElement(AtomicReferenceArray<E> buffer, int offset) {
        return buffer.get(offset);
    }

    protected static int calcElementOffset(long index, long mask) {
        return (int)(index & mask);
    }

    @Override
    public E peek() {
        AtomicReferenceArray buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        int offset = BaseSpscLinkedAtomicArrayQueue.calcElementOffset(index, mask);
        E e = this.lvElement(buffer, offset);
        if (e == JUMP) {
            return this.newBufferPeek(buffer, index);
        }
        return e;
    }

    private E newBufferPeek(AtomicReferenceArray<E> buffer, long index) {
        long newMask;
        AtomicReferenceArray<E> nextBuffer;
        this.consumerBuffer = nextBuffer = this.lvNextArrayAndUnlink(buffer);
        this.consumerMask = newMask = (long)(nextBuffer.length() - 2);
        int offsetInNew = BaseSpscLinkedAtomicArrayQueue.calcElementOffset(index, newMask);
        return this.lvElement(nextBuffer, offsetInNew);
    }

    private E newBufferPoll(AtomicReferenceArray<E> buffer, long index) {
        long newMask;
        AtomicReferenceArray<E> nextBuffer;
        this.consumerBuffer = nextBuffer = this.lvNextArrayAndUnlink(buffer);
        this.consumerMask = newMask = (long)(nextBuffer.length() - 2);
        int offsetInNew = BaseSpscLinkedAtomicArrayQueue.calcElementOffset(index, newMask);
        E n = this.lvElement(nextBuffer, offsetInNew);
        if (null == n) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        this.soConsumerIndex(index + 1L);
        this.soElement(nextBuffer, offsetInNew, null);
        return n;
    }

    @Override
    public final int size() {
        return IndexedQueueSizeUtil.size(this);
    }

    @Override
    public final boolean isEmpty() {
        return IndexedQueueSizeUtil.isEmpty(this);
    }
}

