/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscChunkedArrayQueue;
import org.jctools.queues.QueueProgressIndicators;
import org.jctools.util.Pow2;
import org.jctools.util.RangeUtil;

public class MpscGrowableArrayQueue<E>
extends MpscChunkedArrayQueue<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    public MpscGrowableArrayQueue(int maxCapacity) {
        super(Math.max(2, Pow2.roundToPowerOfTwo(maxCapacity / 8)), maxCapacity);
    }

    public MpscGrowableArrayQueue(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    @Override
    protected int getNextBufferSize(E[] buffer) {
        long maxSize = this.maxQueueCapacity / 2L;
        RangeUtil.checkLessThanOrEqual(buffer.length, maxSize, "buffer.length");
        int newSize = 2 * (buffer.length - 1);
        return newSize + 1;
    }

    @Override
    protected long getCurrentBufferCapacity(long mask) {
        return mask + 2L == this.maxQueueCapacity ? this.maxQueueCapacity : mask;
    }
}

