/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpmcArrayQueue;
import org.jctools.queues.MpscArrayQueueConsumerField;
import org.jctools.queues.QueueProgressIndicators;
import org.jctools.util.UnsafeRefArrayAccess;

public class MpscArrayQueue<E>
extends MpscArrayQueueConsumerField<E>
implements QueueProgressIndicators {
    long p01;
    long p02;
    long p03;
    long p04;
    long p05;
    long p06;
    long p07;
    long p10;
    long p11;
    long p12;
    long p13;
    long p14;
    long p15;
    long p16;
    long p17;

    public MpscArrayQueue(int capacity) {
        super(capacity);
    }

    public boolean offerIfBelowTheshold(E e, int threshold) {
        long currentProducerIndex;
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        long mask = this.mask;
        long consumerIndexCache = this.lvConsumerIndexCache();
        do {
            long wrapPoint;
            if (consumerIndexCache > (wrapPoint = (currentProducerIndex = this.lvProducerIndex()) - (long)threshold)) continue;
            long currHead = this.lvConsumerIndex();
            if (currHead <= wrapPoint) {
                return false;
            }
            this.svConsumerIndexCache(currHead);
            consumerIndexCache = currHead;
        } while (!this.casProducerIndex(currentProducerIndex, currentProducerIndex + 1L));
        long offset = MpscArrayQueue.calcElementOffset(currentProducerIndex, mask);
        UnsafeRefArrayAccess.soElement(this.buffer, offset, e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        long currentProducerIndex;
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        long mask = this.mask;
        long capacity = mask + 1L;
        long consumerIndexCache = this.lvConsumerIndexCache();
        do {
            long wrapPoint;
            if (consumerIndexCache > (wrapPoint = (currentProducerIndex = this.lvProducerIndex()) - capacity)) continue;
            long currHead = this.lvConsumerIndex();
            if (currHead <= wrapPoint) {
                return false;
            }
            this.svConsumerIndexCache(currHead);
            consumerIndexCache = currHead;
        } while (!this.casProducerIndex(currentProducerIndex, currentProducerIndex + 1L));
        long offset = MpscArrayQueue.calcElementOffset(currentProducerIndex, mask);
        UnsafeRefArrayAccess.soElement(this.buffer, offset, e);
        return true;
    }

    public final int failFastOffer(E e) {
        long wrapPoint;
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        long mask = this.mask;
        long capacity = mask + 1L;
        long currentTail = this.lvProducerIndex();
        long consumerIndexCache = this.lvConsumerIndexCache();
        if (consumerIndexCache <= (wrapPoint = currentTail - capacity)) {
            long currHead = this.lvConsumerIndex();
            if (currHead <= wrapPoint) {
                return 1;
            }
            this.svConsumerIndexCache(currHead);
        }
        if (!this.casProducerIndex(currentTail, currentTail + 1L)) {
            return -1;
        }
        long offset = MpscArrayQueue.calcElementOffset(currentTail, mask);
        UnsafeRefArrayAccess.soElement(this.buffer, offset, e);
        return 0;
    }

    @Override
    public E poll() {
        Object[] buffer = this.buffer;
        long consumerIndex = this.lpConsumerIndex();
        long offset = this.calcElementOffset(consumerIndex);
        Object e = UnsafeRefArrayAccess.lvElement(buffer, offset);
        if (null == e) {
            if (consumerIndex != this.lvProducerIndex()) {
                while ((e = UnsafeRefArrayAccess.lvElement(buffer, offset)) == null) {
                }
            } else {
                return null;
            }
        }
        UnsafeRefArrayAccess.spElement(buffer, offset, null);
        this.soConsumerIndex(consumerIndex + 1L);
        return (E)e;
    }

    @Override
    public E peek() {
        Object[] buffer = this.buffer;
        long consumerIndex = this.lpConsumerIndex();
        long offset = this.calcElementOffset(consumerIndex);
        Object e = UnsafeRefArrayAccess.lvElement(buffer, offset);
        if (null == e) {
            if (consumerIndex != this.lvProducerIndex()) {
                while ((e = UnsafeRefArrayAccess.lvElement(buffer, offset)) == null) {
                }
            } else {
                return null;
            }
        }
        return (E)e;
    }

    @Override
    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    @Override
    public boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public E relaxedPoll() {
        Object[] buffer = this.buffer;
        long consumerIndex = this.lpConsumerIndex();
        long offset = this.calcElementOffset(consumerIndex);
        Object e = UnsafeRefArrayAccess.lvElement(buffer, offset);
        if (null == e) {
            return null;
        }
        UnsafeRefArrayAccess.spElement(buffer, offset, null);
        this.soConsumerIndex(consumerIndex + 1L);
        return (E)e;
    }

    @Override
    public E relaxedPeek() {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long consumerIndex = this.lpConsumerIndex();
        return (E)UnsafeRefArrayAccess.lvElement(buffer, MpscArrayQueue.calcElementOffset(consumerIndex, mask));
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return this.drain(c, this.capacity());
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        int filled;
        long result = 0L;
        int capacity = this.capacity();
        do {
            if ((filled = this.fill(s, MpmcArrayQueue.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)result;
        } while ((result += (long)filled) <= (long)capacity);
        return (int)result;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long consumerIndex = this.lpConsumerIndex();
        for (int i = 0; i < limit; ++i) {
            long index = consumerIndex + (long)i;
            long offset = MpscArrayQueue.calcElementOffset(index, mask);
            Object e = UnsafeRefArrayAccess.lvElement(buffer, offset);
            if (null == e) {
                return i;
            }
            UnsafeRefArrayAccess.soElement(buffer, offset, null);
            this.soConsumerIndex(index + 1L);
            c.accept(e);
        }
        return limit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        long available;
        long currentProducerIndex;
        long mask = this.mask;
        long capacity = mask + 1L;
        long cachedConsumerIndex = this.lvConsumerIndexCache();
        int actualLimit = 0;
        do {
            if ((available = capacity - ((currentProducerIndex = this.lvProducerIndex()) - cachedConsumerIndex)) > 0L) continue;
            long currConsumerIndex = this.lvConsumerIndex();
            if ((available += currConsumerIndex - cachedConsumerIndex) <= 0L) {
                return 0;
            }
            this.svConsumerIndexCache(currConsumerIndex);
            cachedConsumerIndex = currConsumerIndex;
        } while (!this.casProducerIndex(currentProducerIndex, currentProducerIndex + (long)(actualLimit = Math.min((int)available, limit))));
        Object[] buffer = this.buffer;
        for (int i = 0; i < actualLimit; ++i) {
            long offset = MpscArrayQueue.calcElementOffset(currentProducerIndex + (long)i, mask);
            UnsafeRefArrayAccess.soElement(buffer, offset, s.get());
        }
        return actualLimit;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long consumerIndex = this.lpConsumerIndex();
        int counter = 0;
        while (exit.keepRunning()) {
            for (int i = 0; i < 4096; ++i) {
                long offset = MpscArrayQueue.calcElementOffset(consumerIndex, mask);
                Object e = UnsafeRefArrayAccess.lvElement(buffer, offset);
                if (null == e) {
                    counter = w.idle(counter);
                    continue;
                }
                counter = 0;
                UnsafeRefArrayAccess.soElement(buffer, offset, null);
                this.soConsumerIndex(++consumerIndex);
                c.accept(e);
            }
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        int idleCounter = 0;
        while (exit.keepRunning()) {
            if (this.fill(s, MpmcArrayQueue.RECOMENDED_OFFER_BATCH) == 0) {
                idleCounter = w.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
        }
    }
}

