/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.privatechef;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.chef.filters.SignedHeaderAuth;
import org.jclouds.chef.functions.ParseKeySetFromJson;
import org.jclouds.privatechef.PatchedChefAsyncApi;
import org.jclouds.privatechef.domain.Organization;
import org.jclouds.privatechef.domain.User;
import org.jclouds.privatechef.functions.OrganizationName;
import org.jclouds.privatechef.functions.Username;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={SignedHeaderAuth.class})
@Consumes(value={"application/json"})
@Headers(keys={"X-Chef-Version"}, values={"{jclouds.api-version}"})
public interface PrivateChefAsyncApi {
    @Delegate
    public PatchedChefAsyncApi getChefApi();

    @GET
    @Path(value="/users")
    @ResponseParser(value=ParseKeySetFromJson.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<String>> listUsers();

    @HEAD
    @Path(value="/users/{username}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> userExists(@PathParam(value="username") String var1);

    @POST
    @Path(value="/users")
    public ListenableFuture<User> createUser(@BinderParam(value=BindToJsonPayload.class) User var1);

    @PUT
    @Path(value="/users/{username}")
    @Consumes(value={"application/json"})
    public ListenableFuture<User> updateUser(@PathParam(value="username") @ParamParser(value=Username.class) @BinderParam(value=BindToJsonPayload.class) User var1);

    @GET
    @Path(value="/users/{username}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    public ListenableFuture<User> getUser(@PathParam(value="username") String var1);

    @DELETE
    @Path(value="/users/{username}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    public ListenableFuture<User> deleteUser(@PathParam(value="username") String var1);

    @GET
    @Path(value="/organizations")
    @ResponseParser(value=ParseKeySetFromJson.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<String>> listOrganizations();

    @HEAD
    @Path(value="/organizations/{organizationname}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> organizationExists(@PathParam(value="organizationname") String var1);

    @POST
    @Path(value="/organizations")
    public ListenableFuture<Organization> createOrganization(@BinderParam(value=BindToJsonPayload.class) Organization var1);

    @PUT
    @Path(value="/organizations/{orgname}")
    @Consumes(value={"application/json"})
    public ListenableFuture<Organization> updateOrganization(@PathParam(value="orgname") @ParamParser(value=OrganizationName.class) @BinderParam(value=BindToJsonPayload.class) Organization var1);

    @GET
    @Path(value="/organizations/{orgname}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    public ListenableFuture<Organization> getOrganization(@PathParam(value="orgname") String var1);

    @DELETE
    @Path(value="/organizations/{orgname}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    public ListenableFuture<Organization> deleteOrganization(@PathParam(value="orgname") String var1);
}

