package org.jboss.bpm.samples.airticket.server;

import java.util.ArrayList;
import java.util.List;

import javax.management.ObjectName;
import javax.servlet.http.HttpSession;

import org.jboss.bpm.client.MessageListener;
import org.jboss.bpm.client.MessageManager;
import org.jboss.bpm.client.ProcessManager;
import org.jboss.bpm.client.SignalListener;
import org.jboss.bpm.client.SignalManager;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.MessageBuilder;
import org.jboss.bpm.model.MessageBuilderFactory;
import org.jboss.bpm.model.ObjectNameFactory;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.Signal;
import org.jboss.bpm.samples.airticket.AirticketProcessBuilder;
import org.jboss.bpm.samples.airticket.client.AirticketService;
import org.jboss.bpm.samples.airticket.client.ConfirmMessage;
import org.jboss.bpm.samples.airticket.client.GwtMessage;
import org.jboss.bpm.samples.airticket.client.InvalidDataMessage;
import org.jboss.bpm.samples.airticket.client.NotAvailableMessage;
import org.jboss.bpm.samples.airticket.client.OfferMessage;
import org.jboss.bpm.samples.airticket.client.OrderMessage;
import org.jboss.bpm.samples.airticket.client.RequestMessage;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

@SuppressWarnings("serial")
public class AirticketServiceImpl extends RemoteServiceServlet implements AirticketService
{
  private ObjectName sampleID = ObjectNameFactory.create("org.jboss.bpm:sample=AirticketService");

  public void sendMessage(GwtMessage gwtMsg)
  {
    ProcessManager pm = ProcessManager.locateProcessManager();
    MessageManager mm = MessageManager.locateMessageManager();
    SignalManager sm = SignalManager.locateSignalManager();

    System.out.println(gwtMsg);

    HttpSession httpSession = getThreadLocalRequest().getSession(false);
    if (httpSession == null)
    {
      System.out.println("Create new Session");
      httpSession = getThreadLocalRequest().getSession();

      List<Message> messageQueue = new ArrayList<Message>();
      AirticketMessageListener msgListener = new AirticketMessageListener(messageQueue);
      mm.addMessageListener(msgListener);
      
      sm.addSignalListener(new AirticketSignalListener());
      
      httpSession.setAttribute("messageQueue", messageQueue);
    }
    
    // Create/Start a new process
    ObjectName procID = (ObjectName)httpSession.getAttribute("procID");
    if (procID == null || pm.getProcessByID(procID) == null)
    {
      System.out.println("Create new Process");
      AirticketProcessBuilder procBuilder = new AirticketProcessBuilder(sampleID);
      Process proc = procBuilder.buildProcess();
      procID = proc.startProcess();
      httpSession.setAttribute("procID", procID);
    }
    
    if (gwtMsg instanceof RequestMessage)
    {
      Message msg = getRequestMessage((RequestMessage)gwtMsg);
      mm.sendMessage(procID, AirticketProcessBuilder.TASK_RECEIVE_REQUEST, msg);
    }
    else if (gwtMsg instanceof OrderMessage)
    {
      Message msg = getOrderMessage((OrderMessage)gwtMsg);
      mm.sendMessage(procID, AirticketProcessBuilder.TASK_RECEIVE_ORDER, msg);
    }
    else
    {
      throw new IllegalStateException(gwtMsg.getClass().getName());
    }
  }

  @SuppressWarnings("unchecked")
  public GwtMessage getMessage()
  {
    HttpSession httpSession = getThreadLocalRequest().getSession(false);
    ArrayList<Message> messageQueue = (ArrayList<Message>)httpSession.getAttribute("messageQueue");
    
    GwtMessage returnMsg = null;
    if (messageQueue.size() > 0)
    {
      Message bpmMsg = messageQueue.remove(0);
      String msgName = bpmMsg.getName();
      if (msgName.equals(AirticketProcessBuilder.MESSAGE_OFFER))
      {
        OfferMessage gwtMsg = new OfferMessage();
        gwtMsg.name = bpmMsg.getPropertyValue(String.class, AirticketProcessBuilder.PROPERTY_NAME);
        gwtMsg.from = bpmMsg.getPropertyValue(String.class, AirticketProcessBuilder.PROPERTY_FROM);
        gwtMsg.to = bpmMsg.getPropertyValue(String.class, AirticketProcessBuilder.PROPERTY_TO);
        gwtMsg.date = bpmMsg.getPropertyValue(String.class, AirticketProcessBuilder.PROPERTY_DATE);
        gwtMsg.seats = bpmMsg.getPropertyValue(Integer.class, AirticketProcessBuilder.PROPERTY_SEATS);
        gwtMsg.price = bpmMsg.getPropertyValue(Integer.class, AirticketProcessBuilder.PROPERTY_PRICE);
        returnMsg = gwtMsg;
      }
      else if (msgName.equals(AirticketProcessBuilder.MESSAGE_INVALID_DATA))
      {
        InvalidDataMessage gwtMsg = new InvalidDataMessage();
        gwtMsg.name = bpmMsg.getPropertyValue(String.class, AirticketProcessBuilder.PROPERTY_NAME);
        gwtMsg.from = bpmMsg.getPropertyValue(String.class, AirticketProcessBuilder.PROPERTY_FROM);
        gwtMsg.to = bpmMsg.getPropertyValue(String.class, AirticketProcessBuilder.PROPERTY_TO);
        gwtMsg.date = bpmMsg.getPropertyValue(String.class, AirticketProcessBuilder.PROPERTY_DATE);
        gwtMsg.seats = bpmMsg.getPropertyValue(Integer.class, AirticketProcessBuilder.PROPERTY_SEATS);
        returnMsg = gwtMsg;
      }
      else if (msgName.equals(AirticketProcessBuilder.MESSAGE_NOT_AVAILABLE))
      {
        NotAvailableMessage gwtMsg = new NotAvailableMessage();
        gwtMsg.name = bpmMsg.getPropertyValue(String.class, AirticketProcessBuilder.PROPERTY_NAME);
        gwtMsg.from = bpmMsg.getPropertyValue(String.class, AirticketProcessBuilder.PROPERTY_FROM);
        gwtMsg.to = bpmMsg.getPropertyValue(String.class, AirticketProcessBuilder.PROPERTY_TO);
        gwtMsg.date = bpmMsg.getPropertyValue(String.class, AirticketProcessBuilder.PROPERTY_DATE);
        gwtMsg.seats = bpmMsg.getPropertyValue(Integer.class, AirticketProcessBuilder.PROPERTY_SEATS);
        returnMsg = gwtMsg;
      }
      else if (msgName.equals(AirticketProcessBuilder.MESSAGE_CONFIRM))
      {
        ConfirmMessage gwtMsg = new ConfirmMessage();
        gwtMsg.name = bpmMsg.getPropertyValue(String.class, AirticketProcessBuilder.PROPERTY_NAME);
        gwtMsg.from = bpmMsg.getPropertyValue(String.class, AirticketProcessBuilder.PROPERTY_FROM);
        gwtMsg.to = bpmMsg.getPropertyValue(String.class, AirticketProcessBuilder.PROPERTY_TO);
        gwtMsg.date = bpmMsg.getPropertyValue(String.class, AirticketProcessBuilder.PROPERTY_DATE);
        gwtMsg.seats = bpmMsg.getPropertyValue(Integer.class, AirticketProcessBuilder.PROPERTY_SEATS);
        gwtMsg.price = bpmMsg.getPropertyValue(Integer.class, AirticketProcessBuilder.PROPERTY_PRICE);
        returnMsg = gwtMsg;
      }
      else
      {
        throw new IllegalStateException(msgName);
      }
    }
    return returnMsg;
  }

  private Message getRequestMessage(RequestMessage gwtMsg)
  {
    MessageBuilderFactory msgFactory = MessageBuilderFactory.newInstance();
    MessageBuilder msgBuilder = msgFactory.newMessageBuilder();
    Message msg = msgBuilder.newMessage(AirticketProcessBuilder.MESSAGE_REQ_DATA).
    addProperty(AirticketProcessBuilder.PROPERTY_NAME, gwtMsg.name).
    addProperty(AirticketProcessBuilder.PROPERTY_FROM, gwtMsg.from).
    addProperty(AirticketProcessBuilder.PROPERTY_TO, gwtMsg.to).
    addProperty(AirticketProcessBuilder.PROPERTY_DATE, gwtMsg.date).
    addProperty(AirticketProcessBuilder.PROPERTY_SEATS, gwtMsg.seats).
    getMessage();
    return msg;
  }

  private Message getOrderMessage(OrderMessage gwtMsg)
  {
    MessageBuilderFactory msgFactory = MessageBuilderFactory.newInstance();
    MessageBuilder msgBuilder = msgFactory.newMessageBuilder();
    Message msg = msgBuilder.newMessage(AirticketProcessBuilder.MESSAGE_ACCEPT_OFFER).
    addProperty(AirticketProcessBuilder.PROPERTY_CREDIT_CARD, gwtMsg.creditCard).
    addProperty(AirticketProcessBuilder.PROPERTY_EXPIRE, gwtMsg.expire).
    addProperty(AirticketProcessBuilder.PROPERTY_IS_OFFER_ACCEPTED, "" + gwtMsg.acceptOffer).
    getMessage();
    return msg;
  }

  class AirticketMessageListener implements MessageListener
  {
    private List<Message> messageQueue;
    
    public AirticketMessageListener(List<Message> messageQueue)
    {
      this.messageQueue = messageQueue;
    }

    public void catchMessage(Message message)
    {
      messageQueue.add(message);
      System.out.println("catchMessage: " + message);
    }

    public ObjectName getID()
    {
      return sampleID;
    }
  }

  class AirticketSignalListener implements SignalListener
  {
    public boolean acceptSignal(Signal signal)
    {
      return true;
    }

    public void catchSignal(Signal signal)
    {
      System.out.println(signal);
    }
  }
}
