/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.variables;

import java.io.Serializable;
import java.util.Date;
import org.jbpm.test.JbpmTestCase;

public class VariableBasicTypesTest
extends JbpmTestCase {
    public void checkVariableValue(Object variableValue) {
        this.deployJpdlXmlString("<process name='var'>  <start name='a'>    <transition to='b' />  </start>  <state name='b'/></process>");
        this.executionService.startProcessInstanceByKey("var", "one");
        this.executionService.setVariable("var.one", "msg", variableValue);
        VariableBasicTypesTest.assertEquals((Object)variableValue, (Object)this.executionService.getVariable("var.one", "msg"));
    }

    public void testVariableTypeString() {
        this.checkVariableValue("hello");
    }

    public void testVariableTypeCharacter() {
        this.checkVariableValue(new Character('x'));
    }

    public void testVariableTypeBoolean() {
        this.checkVariableValue(Boolean.TRUE);
    }

    public void testVariableTypeByte() {
        this.checkVariableValue(new Byte(5));
    }

    public void testVariableTypeShort() {
        this.checkVariableValue(new Short(5));
    }

    public void testVariableTypeInteger() {
        this.checkVariableValue(new Integer(5));
    }

    public void testVariableTypeLong() {
        this.checkVariableValue(new Long(5L));
    }

    public void testVariableTypeFloat() {
        this.checkVariableValue(new Float(5.7));
    }

    public void testVariableTypeDouble() {
        this.checkVariableValue(new Double(5.7));
    }

    public void testVariableTypeDate() {
        this.checkVariableValue(new Date());
    }

    public void testVariableTypeSerializable() {
        SerializeMe originalValue = new SerializeMe(this.generateString("a lot of text ", 500));
        this.checkVariableValue(originalValue);
        SerializeMe newValue = new SerializeMe(this.generateString("another text ", 500));
        this.executionService.setVariable("var.one", "msg", (Object)newValue);
        VariableBasicTypesTest.assertEquals((Object)newValue, (Object)this.executionService.getVariable("var.one", "msg"));
    }

    protected String generateString(String base, int multiplier) {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < multiplier; ++i) {
            text.append(base);
        }
        return text.toString();
    }

    public static class SerializeMe
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String text;

        public SerializeMe(String text) {
            this.text = text;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SerializeMe other = (SerializeMe)obj;
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }
    }
}

