/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.task;

import java.util.List;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class ForkSwimlaneTest
extends JbpmTestCase {
    private static final String PROCESS_XML = "<process name='ForkSwimlane' xmlns='http://jbpm.org/4.3/jpdl'>   <swimlane candidate-groups='A' name='A'/>   <swimlane candidate-groups='B' name='B'/>   <start name='start'>      <transition to='task1A'/>   </start>   <task name='task1A' swimlane='A'>      <transition to='task1B'/>   </task>   <task name='task1B' swimlane='B'>      <transition to='fork'/>   </task>   <fork name='fork'>      <transition to='task2A'/>      <transition to='task2B'/>   </fork>   <task name='task2A' swimlane='A'>      <transition to='join'/>   </task>   <task name='task2B' swimlane='B'>      <transition to='join'/>   </task>   <join name='join'>      <transition to='end'/>   </join>   <end name='end'/></process>";

    protected void setUp() throws Exception {
        super.setUp();
        String groupA = this.identityService.createGroup("A");
        String groupB = this.identityService.createGroup("B");
        this.identityService.createUser("lingo", "lingo", "lingo");
        this.identityService.createMembership("lingo", groupA, "lingo-groupA");
        this.identityService.createMembership("lingo", groupB, "lingo-groupB");
        this.deployJpdlXmlString(PROCESS_XML);
    }

    protected void tearDown() throws Exception {
        this.identityService.deleteGroup("A");
        this.identityService.deleteGroup("B");
        this.identityService.deleteUser("lingo");
        super.tearDown();
    }

    public void testSwimlane() {
        this.executionService.startProcessInstanceByKey("ForkSwimlane");
        this.takeAndCompleteTask("lingo");
        this.takeAndCompleteTask("lingo");
        this.completeTask("lingo");
        this.completeTask("lingo");
    }

    protected void takeAndCompleteTask(String username) {
        List tasks = this.taskService.findGroupTasks(username);
        Task task = (Task)tasks.get(0);
        this.taskService.takeTask(task.getId(), username);
        this.taskService.completeTask(task.getId());
    }

    protected void completeTask(String username) {
        List tasks = this.taskService.findPersonalTasks(username);
        Task task = (Task)tasks.get(0);
        this.taskService.completeTask(task.getId());
    }
}

