/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.subprocess;

import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class SubProcessTest
extends JbpmTestCase {
    private static final String MAIN_PROCESS = "<process name='mainProcess'>  <start>    <transition to='review' />  </start>  <sub-process name='review' sub-process-key='SubProcessReview'>    <transition name='ok' to='next step'/>    <transition name='nok' to='update'/>    <transition name='reject' to='close'/>  </sub-process>  <state name='next step'/>  <state name='update'>    <transition to='close'/>  </state>  <end name='close'/></process>";
    private static final String SUB_PROCESS = "<process name='SubProcessReview'>  <start>    <transition to='get approval'/>  </start>  <task name='get approval' assignee='johndoe'>    <transition name='ok' to='ok'/>    <transition name='nok' to='nok'/>    <transition name='reject' to='reject'/>  </task>  <end name='ok' />  <end name='nok' />  <end name='reject' /></process>";
    private static final String MAIN_PROCESS_NO_WAIT_STATE = "<process name='mainProcess'>  <start>    <transition to='review' />  </start>  <sub-process name='review' sub-process-key='SubProcessReview'>    <transition to='theMainEnd'/>  </sub-process>  <end name='theMainEnd'/></process>";
    private static final String SUB_PROCESS_NO_WAIT_STATE = "<process name='SubProcessReview'>  <start>    <transition to='theEnd'/>  </start>  <end name='theEnd' /></process>";

    public void testSubProcessOutcomeToState() {
        this.deployJpdlXmlString(SUB_PROCESS);
        this.deployJpdlXmlString(MAIN_PROCESS);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("mainProcess");
        SubProcessTest.assertEquals((int)2, (int)this.executionService.createProcessInstanceQuery().list().size());
        Task task = (Task)this.taskService.findPersonalTasks("johndoe").get(0);
        this.taskService.completeTask(task.getId(), "nok");
        this.assertActivityActive(processInstance.getId(), "update");
        processInstance = this.executionService.signalExecutionById(processInstance.getId());
        this.assertProcessInstanceEnded(processInstance);
        SubProcessTest.assertEquals((int)0, (int)this.executionService.createProcessInstanceQuery().list().size());
    }

    public void testSubProcessOutcomeToEnd() {
        this.deployJpdlXmlString(SUB_PROCESS);
        this.deployJpdlXmlString(MAIN_PROCESS);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("mainProcess");
        SubProcessTest.assertEquals((int)2, (int)this.executionService.createProcessInstanceQuery().list().size());
        Task task = (Task)this.taskService.findPersonalTasks("johndoe").get(0);
        this.taskService.completeTask(task.getId(), "reject");
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testSubProcessNoWaitStates() {
        this.deployJpdlXmlString(SUB_PROCESS_NO_WAIT_STATE);
        this.deployJpdlXmlString(MAIN_PROCESS_NO_WAIT_STATE);
        this.executionService.startProcessInstanceByKey("mainProcess");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("mainProcess");
        this.assertProcessInstanceEnded(processInstance);
        SubProcessTest.assertEquals((int)0, (int)this.executionService.createProcessInstanceQuery().list().size());
    }
}

